/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSAdminRights;

import it.starblue.LFS.LFSAdminRights.Connection;
import it.starblue.LFS.LFSAdminRights.HostListener;
import it.starblue.LFS.LFSAdminRights.LFSAdminRights;
import it.starblue.LFS.LFSAdminRights.LoggedCommand;
import it.starblue.LFS.LFSAdminRights.Screens.AdminMainScreen;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import net.sf.jinsim.Channel;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.ButtonFunctionRequest;
import net.sf.jinsim.request.ButtonRequest;
import net.sf.jinsim.request.ButtonSubtype;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.request.MessageRequest;
import net.sf.jinsim.request.MessageToConnectionRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.MessageResponse;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Host {
    private static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSEnduroTracker.Host");
    private String hostname = "";
    private int port = 0;
    private String password = "";
    private char prefix;
    private SimpleClient jinsimClient = new SimpleClient();
    private boolean initalized = false;
    private int req = 1;
    private HashMap<Byte, Connection> connections = new HashMap();
    private Vector<LoggedCommand> loggedCommands = new Vector();

    public Host(String string, int n, String string2, char c) {
        this.hostname = string;
        this.password = string2;
        this.port = n;
        this.prefix = c;
        this.initializeInsimConnection();
    }

    private void initializeInsimConnection() {
        try {
            this.jinsimClient = new SimpleClient();
            TCPChannel tCPChannel = new TCPChannel(this.hostname, this.port);
            this.jinsimClient.addListener((InSimListener)new HostListener(this));
            this.jinsimClient.connect((Channel)tCPChannel, this.password, "AdmRts", (short)0, 0, 0, this.prefix);
            log.info((Object)(this + " connection initialized."));
            this.requestAllConnections();
            this.requestAllPlayers();
            this.initalized = true;
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Can't connect to LFS server!"), (Throwable)iOException);
            this.initalized = false;
        }
    }

    private void requestAllConnections() {
        TinyRequest tinyRequest = new TinyRequest(Tiny.ALL_CONNECTIONS);
        try {
            this.jinsimClient.send((InSimRequest)tinyRequest);
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Failed to request all connections!"), (Throwable)iOException);
        }
    }

    private void requestAllPlayers() {
        TinyRequest tinyRequest = new TinyRequest(Tiny.ALL_PLAYERS);
        try {
            this.jinsimClient.send((InSimRequest)tinyRequest);
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Failed to request all players!"), (Throwable)iOException);
        }
    }

    public void testConnection() {
        if (this.initalized) {
            try {
                log.debug((Object)(this + " Checking connection..."));
                this.jinsimClient.send((InSimRequest)new TinyRequest(Tiny.NONE));
            }
            catch (IOException iOException) {
                log.error((Object)(this + " Test connection failed, re-inizializing Insim now"), (Throwable)iOException);
                this.initalized = false;
                this.initializeInsimConnection();
            }
        } else {
            this.initializeInsimConnection();
        }
    }

    public synchronized void addConnection(Connection connection) {
        this.connections.put(connection.getConnId(), connection);
    }

    public synchronized void removeConnection(byte by) {
        this.connections.remove(by);
    }

    public Connection getConnection(byte by) {
        return this.connections.get(by);
    }

    public String toString() {
        return "[" + this.hostname + ":" + this.port + "]";
    }

    public void clearAllButtons(byte by) {
        ButtonFunctionRequest buttonFunctionRequest = new ButtonFunctionRequest();
        buttonFunctionRequest.setSubtype(ButtonSubtype.CLEAR);
        buttonFunctionRequest.setConnectionId(by);
        try {
            this.jinsimClient.send((InSimRequest)buttonFunctionRequest);
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Failed to clear all buttons!"), (Throwable)iOException);
        }
    }

    public void createTextButton(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, byte by) {
        ButtonRequest buttonRequest = new ButtonRequest();
        buttonRequest.setRequestInfo((byte)(this.req % 256 + 1));
        buttonRequest.setConnectionId(by);
        buttonRequest.setText(string);
        buttonRequest.setHeight((byte)n2);
        buttonRequest.setWidth((byte)n3);
        buttonRequest.setLeft((byte)n4);
        buttonRequest.setTop((byte)n5);
        buttonRequest.setClickId((byte)n6);
        buttonRequest.setTypeIn((byte)n);
        buttonRequest.setButtonStyle(n7);
        try {
            this.jinsimClient.send((InSimRequest)buttonRequest);
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Failed to create Text button!"), (Throwable)iOException);
        }
    }

    public void createButton(String string, int n, int n2, int n3, int n4, int n5, int n6, byte by) {
        this.createTextButton(0, string, n, n2, n3, n4, n5, n6, by);
    }

    public void warnUsername(String string, String string2) {
        for (Connection connection : this.connections.values()) {
            if (!connection.getUsername().equalsIgnoreCase(string)) continue;
            this.sendMessageToConnection(connection.getConnId(), string2);
        }
    }

    public void sendMessageToConnection(byte by, String string) {
        MessageToConnectionRequest messageToConnectionRequest = new MessageToConnectionRequest();
        messageToConnectionRequest.setConnectionId((int)by);
        messageToConnectionRequest.setMessage(string);
        try {
            this.jinsimClient.send((InSimRequest)messageToConnectionRequest);
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Failed to create Send Message to Connection!"), (Throwable)iOException);
        }
    }

    public void displayAdminPanel(byte by) {
        Connection connection = this.getConnection(by);
        if (connection.isAdmin()) {
            AdminMainScreen adminMainScreen = new AdminMainScreen(connection.getConnId(), this);
            connection.setCurrentScreen(adminMainScreen);
        }
    }

    public void clickButton(Connection connection, byte by, boolean bl) {
        if (connection.getCurrentScreen() != null) {
            connection.setCurrentScreen(connection.getCurrentScreen().processClicks(by, bl));
        }
    }

    public void updateTexts(Connection connection, byte by, String string) {
        if (connection.getCurrentScreen() != null) {
            connection.getCurrentScreen().updateTexts(by, string);
        }
    }

    public void sendMessage(String string) {
        MessageRequest messageRequest = new MessageRequest();
        messageRequest.setMessage(string);
        try {
            this.jinsimClient.send((InSimRequest)messageRequest);
        }
        catch (IOException iOException) {
            log.error((Object)(this + " Failed to Send Message!"), (Throwable)iOException);
        }
    }

    public void execute(MessageResponse messageResponse) {
        Connection connection = this.getConnection(messageResponse.getConnectionId());
        String string = connection.getUsername();
        String string2 = messageResponse.getMessage();
        String string3 = "";
        String string4 = "";
        if (string2.indexOf(" ") != -1) {
            string3 = string2.substring(1, string2.indexOf(" "));
            string4 = string2.substring(string2.indexOf(" "));
        } else {
            string3 = string2.substring(1);
        }
        log.info((Object)(string + " is trying to execute " + this.getPrefix() + string3 + string4));
        boolean bl = LFSAdminRights.checkRights(string, string3);
        if (bl) {
            log.info((Object)(string + " is authorized for " + this.getPrefix() + string3));
            String string5 = LFSAdminRights.getTranslation(string3);
            this.logCommand(new LoggedCommand(new Date(), string, string3, string5, string4));
            this.sendMessage(string5 + string4);
        } else {
            log.info((Object)(string + " is NOT authorized for " + this.getPrefix() + string3));
        }
    }

    private synchronized void logCommand(LoggedCommand loggedCommand) {
        if (this.loggedCommands.size() > 99) {
            this.loggedCommands.removeElementAt(0);
        }
        this.loggedCommands.add(loggedCommand);
    }

    public synchronized Vector<LoggedCommand> getLoggedCommands() {
        return (Vector)this.loggedCommands.clone();
    }

    public char getPrefix() {
        return this.prefix;
    }
}

