/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

public class VersionResponse
extends InSimResponse {
    public static final String TYPE = "VER";
    private String version;
    private String product;
    private short netVersion;

    VersionResponse() {
        super(PacketType.VERSION);
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.setVersion(this.getString(buffer, 8));
        this.setProduct(this.getString(buffer, 6));
        this.setNetVersion(buffer.getShort());
    }

    public String toString() {
        String retval = super.toString();
        retval = retval + "Product: " + this.getProduct() + "\n";
        retval = retval + "Version: " + this.getVersion() + "\n";
        retval = retval + "Net Protocol Version: " + this.getNetVersion() + "\n";
        return retval;
    }

    public short getNetVersion() {
        return this.netVersion;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public void setNetVersion(short netVersion) {
        this.netVersion = netVersion;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

