/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.AutocrossHit;
import net.sf.jinsim.response.AutocrossLayoutResponse;
import net.sf.jinsim.response.ButtonClickedResponse;
import net.sf.jinsim.response.ButtonFunctionResponse;
import net.sf.jinsim.response.ButtonTypeResponse;
import net.sf.jinsim.response.CameraChangedResponse;
import net.sf.jinsim.response.CameraPositionResponse;
import net.sf.jinsim.response.CarResetResponse;
import net.sf.jinsim.response.ConnectionLeaveResponse;
import net.sf.jinsim.response.ConnectionPlayerRenameResponse;
import net.sf.jinsim.response.FinishedRaceResponse;
import net.sf.jinsim.response.FlagResponse;
import net.sf.jinsim.response.HiddenMessageResponse;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.LapTimeResponse;
import net.sf.jinsim.response.MessageResponse;
import net.sf.jinsim.response.MultiCarInfoResponse;
import net.sf.jinsim.response.MultiplayerBeginResponse;
import net.sf.jinsim.response.NewConnectionResponse;
import net.sf.jinsim.response.NewPlayerResponse;
import net.sf.jinsim.response.NodeLapInfoResponse;
import net.sf.jinsim.response.NoneResponse;
import net.sf.jinsim.response.PenaltyResponse;
import net.sf.jinsim.response.PitLaneResponse;
import net.sf.jinsim.response.PitStopFinishedResponse;
import net.sf.jinsim.response.PitStopResponse;
import net.sf.jinsim.response.PlayerFlagResponse;
import net.sf.jinsim.response.PlayerLeavingResponse;
import net.sf.jinsim.response.PlayerPitsResponse;
import net.sf.jinsim.response.RaceStartResponse;
import net.sf.jinsim.response.ReorderResponse;
import net.sf.jinsim.response.ResultResponse;
import net.sf.jinsim.response.SmallResponse;
import net.sf.jinsim.response.SplitTimeResponse;
import net.sf.jinsim.response.StateResponse;
import net.sf.jinsim.response.TakeOverCarResponse;
import net.sf.jinsim.response.TinyResponse;
import net.sf.jinsim.response.UnhandledPacketTypeException;
import net.sf.jinsim.response.VersionResponse;
import net.sf.jinsim.response.VoteNotificationResponse;
import net.sf.jinsim.response.relay.HostListResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseFactory {
    public static final Log log = LogFactory.getLog(ResponseFactory.class);
    private HashMap<PacketType, Class<? extends InSimResponse>> registeredTypes = new HashMap(53);
    private static ResponseFactory instance;

    private ResponseFactory() {
        this.registeredTypes.put(PacketType.NONE, NoneResponse.class);
        this.registeredTypes.put(PacketType.VERSION, VersionResponse.class);
        this.registeredTypes.put(PacketType.CONNECTION_PLAYER_RENAMED, ConnectionPlayerRenameResponse.class);
        this.registeredTypes.put(PacketType.TINY, TinyResponse.class);
        this.registeredTypes.put(PacketType.SMALL, SmallResponse.class);
        this.registeredTypes.put(PacketType.STATE, StateResponse.class);
        this.registeredTypes.put(PacketType.CAMERA_POSITION, CameraPositionResponse.class);
        this.registeredTypes.put(PacketType.START_MULTIPLAYER, MultiplayerBeginResponse.class);
        this.registeredTypes.put(PacketType.MESSAGE_OUT, MessageResponse.class);
        this.registeredTypes.put(PacketType.HIDDEN_MESSAGE, HiddenMessageResponse.class);
        this.registeredTypes.put(PacketType.VOTE_NOTIFICATION, VoteNotificationResponse.class);
        this.registeredTypes.put(PacketType.RACE_START, RaceStartResponse.class);
        this.registeredTypes.put(PacketType.NEW_CONNECTION, NewConnectionResponse.class);
        this.registeredTypes.put(PacketType.CONNECTION_LEFT, ConnectionLeaveResponse.class);
        this.registeredTypes.put(PacketType.CONNECTION_PLAYER_RENAMED, ConnectionPlayerRenameResponse.class);
        this.registeredTypes.put(PacketType.NEW_PLAYER, NewPlayerResponse.class);
        this.registeredTypes.put(PacketType.PLAYER_PIT, PlayerPitsResponse.class);
        this.registeredTypes.put(PacketType.PLAYER_LEAVE, PlayerLeavingResponse.class);
        this.registeredTypes.put(PacketType.LAP, LapTimeResponse.class);
        this.registeredTypes.put(PacketType.SPLIT, SplitTimeResponse.class);
        this.registeredTypes.put(PacketType.PIT, PitStopResponse.class);
        this.registeredTypes.put(PacketType.PIT_FINISHED, PitStopFinishedResponse.class);
        this.registeredTypes.put(PacketType.PIT_LANE, PitLaneResponse.class);
        this.registeredTypes.put(PacketType.CAMERA_CHANGED, CameraChangedResponse.class);
        this.registeredTypes.put(PacketType.PENALTY, PenaltyResponse.class);
        this.registeredTypes.put(PacketType.TAKE_OVER_CAR, TakeOverCarResponse.class);
        this.registeredTypes.put(PacketType.FLAG, FlagResponse.class);
        this.registeredTypes.put(PacketType.PLAYER_FLAGS, PlayerFlagResponse.class);
        this.registeredTypes.put(PacketType.FINISHED_RACE, FinishedRaceResponse.class);
        this.registeredTypes.put(PacketType.RESULT_CONFIRMED, ResultResponse.class);
        this.registeredTypes.put(PacketType.REORDER, ReorderResponse.class);
        this.registeredTypes.put(PacketType.NODE_LAP, NodeLapInfoResponse.class);
        this.registeredTypes.put(PacketType.MULIT_CAR_INFO, MultiCarInfoResponse.class);
        this.registeredTypes.put(PacketType.CAR_RESET, CarResetResponse.class);
        this.registeredTypes.put(PacketType.BUTTON_FUNCTION, ButtonFunctionResponse.class);
        this.registeredTypes.put(PacketType.BUTTON_CLICKED, ButtonClickedResponse.class);
        this.registeredTypes.put(PacketType.BUTTON_TYPED, ButtonTypeResponse.class);
        this.registeredTypes.put(PacketType.RELAY_HOST_LIST_INFO, HostListResponse.class);
        this.registeredTypes.put(PacketType.AUTOCROSS_LAYOUT, AutocrossLayoutResponse.class);
        this.registeredTypes.put(PacketType.AUTOCROSS_HIT, AutocrossHit.class);
    }

    public static ResponseFactory getInstance() {
        if (instance == null) {
            instance = new ResponseFactory();
        }
        return instance;
    }

    public InSimResponse getPacketData(ByteBuffer buffer) throws UnhandledPacketTypeException, BufferUnderflowException, InstantiationException, IllegalAccessException {
        InSimResponse insimResponse = null;
        if (buffer.limit() >= 3) {
            int packetId = buffer.get() & 0xFF;
            PacketType packetType = PacketType.getPacket(packetId);
            Class<? extends InSimResponse> insimResponseClass = this.registeredTypes.get((Object)packetType);
            if (insimResponseClass == null) {
                buffer.position(buffer.limit());
                throw new UnhandledPacketTypeException(packetId + ": is unkown");
            }
            insimResponse = insimResponseClass.newInstance();
        } else if (log.isDebugEnabled()) {
            String bufferBytes = "";
            for (int i = 0; i < buffer.limit(); ++i) {
                bufferBytes = bufferBytes + buffer.get() + ", ";
            }
            log.debug((Object)("unknown packet: " + bufferBytes));
        } else {
            buffer.position(buffer.limit());
        }
        if (insimResponse == null) {
            throw new UnhandledPacketTypeException("Can not identify response packet");
        }
        try {
            insimResponse.construct(buffer);
        }
        catch (BufferUnderflowException ex) {
            log.error((Object)ex);
        }
        return insimResponse;
    }
}

