/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorderResponse
extends InSimResponse {
    private ArrayList<Byte> playerPositions = new ArrayList(32);
    private byte numberPlayers;

    ReorderResponse() {
        super(PacketType.REORDER);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.numberPlayers = buffer.get();
        for (int i = 1; i < 32; ++i) {
            this.playerPositions.add(new Byte(buffer.get()));
        }
    }

    @Override
    public String toString() {
        String value = super.toString();
        value = value + "Number of players: " + this.getNumberPlayers();
        value = value + ", positions: ";
        for (Byte position : this.playerPositions) {
            value = value + position + ", ";
        }
        return value;
    }

    public byte getPlayerPositionAt(int n) {
        return this.playerPositions.get(n);
    }

    public ArrayList<Byte> getPlayerPositions() {
        return this.playerPositions;
    }

    public byte getNumberPlayers() {
        return this.numberPlayers;
    }

    public void setNumberPlayers(byte numPlayers) {
        this.numberPlayers = numPlayers;
    }
}

