/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;

public class PitLaneResponse
extends PlayerResponse {
    public static final int PITLANE_EXIT = 0;
    public static final int PITLANE_ENTER = 1;
    public static final int PITLANE_NO_PURPOSE = 2;
    public static final int PITLANE_DT = 3;
    public static final int PITLANE_SG = 4;
    private int fact;

    public PitLaneResponse() {
        super(PacketType.PIT_LANE);
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.fact = buffer.get();
        buffer.position(buffer.position() + 3);
    }

    public String toString() {
        return super.toString() + "fact: " + this.fact;
    }

    public boolean isPitsExit() {
        return this.fact == 0;
    }

    public boolean isPitsEntered() {
        return this.fact == 1;
    }

    public boolean isPitsNoPurpose() {
        return this.fact == 2;
    }

    public boolean isPitsDriveThrough() {
        return this.fact == 3;
    }

    public boolean isPitsStopAndGo() {
        return this.fact == 4;
    }
}

