/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.Encoding;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

public class MessageResponse
extends InSimResponse {
    private String message;
    private String driverName;
    private byte connectionId;
    private byte playerId;
    private byte typedByUser;
    private byte textStart;

    public MessageResponse() {
        super(PacketType.MESSAGE_OUT);
    }

    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        buffer.position(buffer.position() + 1);
        this.connectionId = buffer.get();
        this.playerId = buffer.get();
        this.typedByUser = buffer.get();
        this.textStart = buffer.get();
        byte[] rawMessage = this.getBytes(buffer, 128);
        byte[] rawDriverName = new byte[this.textStart];
        System.arraycopy(rawMessage, 0, rawDriverName, 0, this.textStart);
        byte[] rawMessageText = new byte[128 - this.textStart];
        System.arraycopy(rawMessage, this.textStart, rawMessageText, 0, 128 - this.textStart);
        this.driverName = Encoding.decodeString(rawDriverName);
        this.message = Encoding.decodeString(rawMessageText);
    }

    public String toString() {
        String retval = super.toString();
        retval = retval + this.getMessage() + "\n";
        return retval;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public byte getConnectionId() {
        return this.connectionId;
    }

    public byte getPlayerId() {
        return this.playerId;
    }

    public byte getTextStart() {
        return this.textStart;
    }

    public byte getTypedByUser() {
        return this.typedByUser;
    }

    public String getDriverName() {
        return this.driverName;
    }
}

