/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.request.relay;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.request.relay.InSimRelayRequest;

public class SelectHostRequest
extends InSimRelayRequest {
    private String hostname;
    private String spectatorPassword = "";
    private String adminPassword = "";

    public SelectHostRequest(String hostname, String spectatorPassword, String adminPassword) {
        super(PacketType.RELAY_SELECT_HOST, (byte)68);
        this.hostname = hostname;
        this.spectatorPassword = spectatorPassword;
        this.adminPassword = adminPassword;
    }

    public SelectHostRequest(String hostname) {
        this(hostname, "", "");
    }

    public void assemble(ByteBuffer buffer) {
        super.assemble(buffer);
        buffer.position(buffer.position() + 1);
        this.assembleString(buffer, this.hostname, 32);
        this.assembleString(buffer, this.adminPassword, 16);
        this.assembleString(buffer, this.spectatorPassword, 16);
    }

    public String toString() {
        return "SelectHostRequest[hostname=" + this.hostname + "]";
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setSpectatorPassword(String spectatorPassword) {
        this.spectatorPassword = spectatorPassword;
    }
}

