/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.relay;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.sf.jinsim.RelayClient;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.request.relay.HostListRequest;
import net.sf.jinsim.request.relay.SelectHostRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.relay.HostListResponse;
import net.sf.jinsim.response.relay.RelayErrorResponse;
import net.sf.jinsim.types.HostInfo;

public class Main
implements InSimListener {
    private RelayClient client;
    private String adminPassword;
    private List<HostInfo> hostList = Collections.emptyList();

    public Main(String[] args) {
        if (args.length > 0) {
            this.adminPassword = args[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.client = new RelayClient();
            this.client.connect(this.adminPassword);
            this.client.addListener(this);
            HostListRequest request = new HostListRequest();
            this.client.send(request);
            Thread.sleep(1000L);
            this.connectToFirstHost();
            Thread.sleep(1000L);
            this.client.send(new TinyRequest(Tiny.SEND_STATE_INFO));
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void connectToFirstHost() {
        for (HostInfo info : this.hostList) {
            if (info.isRequiresPassword()) continue;
            SelectHostRequest request = new SelectHostRequest(info.getHostname());
            try {
                this.client.send(request);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public static void main(String[] args) {
        if (args.length <= 1) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.examples.relay.Main <admin password>");
        }
    }

    public void packetReceived(InSimResponse response) {
        if (response instanceof HostListResponse) {
            HostListResponse hostListResponse = (HostListResponse)response;
            for (HostInfo info : hostListResponse.getHostList()) {
                System.out.println(info);
            }
            this.hostList = hostListResponse.getHostList();
        } else if (response instanceof RelayErrorResponse) {
            System.out.println(response);
        } else {
            System.out.println(response);
        }
    }
}

