/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.queue;

import java.io.IOException;
import net.sf.jinsim.QueueClient;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.examples.queue.SimpleInSimListener;
import net.sf.jinsim.request.TinyRequest;

public class Main {
    private QueueClient client;
    private String hostname;
    private int port;
    private String adminPassword;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.client = new QueueClient();
            TCPChannel channel = new TCPChannel(this.hostname, this.port);
            SimpleInSimListener firstListener = new SimpleInSimListener("====> FIRST");
            SimpleInSimListener secondListener = new SimpleInSimListener("====> SECOND");
            this.client.addListener(firstListener);
            this.client.addListener(secondListener);
            this.client.setRequestVersion(false);
            this.client.connect(channel, this.adminPassword, "QueueTest");
            this.client.send(new TinyRequest(Tiny.VERSION));
            this.client.send(new TinyRequest(Tiny.VERSION), firstListener);
            this.client.send(new TinyRequest(Tiny.VERSION), firstListener);
            this.client.send(new TinyRequest(Tiny.VERSION), firstListener);
            this.client.send(new TinyRequest(Tiny.VERSION), secondListener);
            this.client.send(new TinyRequest(Tiny.VERSION), firstListener);
            this.client.send(new TinyRequest(Tiny.VERSION), firstListener);
            this.client.send(new TinyRequest(Tiny.VERSION), firstListener);
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.queue.Main <hostname> <port> <admin password>");
        }
    }
}

