/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.nodelap;

import java.io.IOException;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.MessageExtendedRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.NodeLapInfoResponse;

public class NodeLapExample
implements InSimListener {
    private SimpleClient client;
    private String hostname;
    private int port;
    private String adminPassword;

    public NodeLapExample(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.client = new SimpleClient();
            TCPChannel channel = new TCPChannel(this.hostname, this.port);
            this.client.addListener(this);
            this.client.connect(channel, this.adminPassword, "NodeLapExample");
            MessageExtendedRequest msgRequest = new MessageExtendedRequest();
            msgRequest.setMessage("NodeLapExample");
            this.client.send(msgRequest);
            for (int i = 0; i < 10; ++i) {
                this.client.send(new TinyRequest(Tiny.NODE_LAP));
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void packetReceived(InSimResponse response) {
        if (response instanceof NodeLapInfoResponse) {
            NodeLapInfoResponse nodeLap = (NodeLapInfoResponse)response;
            System.out.println(nodeLap);
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            NodeLapExample testConnect = new NodeLapExample(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.nodelap.NodeLapExample <hostname> <port> <admin password>");
        }
    }
}

