/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import net.sf.jinsim.AbstractChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPChannel
extends AbstractChannel {
    private ByteBuffer cacheBuffer = ByteBuffer.allocate(1024);
    static Log log = LogFactory.getLog(UDPChannel.class);
    protected DatagramChannel datagramChannel = DatagramChannel.open();
    private MulticastSocket multicastSocket;
    protected InetSocketAddress address;

    public UDPChannel(String host, int port, boolean multicast) throws IOException {
        this(new InetSocketAddress(host, port), multicast);
    }

    public UDPChannel(String host, int port) throws IOException {
        this(host, port, false);
    }

    public UDPChannel(InetSocketAddress address, boolean multicast) throws IOException {
        this.datagramChannel.configureBlocking(false);
        this.datagramChannel.socket().bind(null);
        this.address = address;
        if (multicast) {
            InetAddress group = InetAddress.getByName("223.223.223.223");
            this.multicastSocket = new MulticastSocket();
            this.multicastSocket.joinGroup(group);
        }
    }

    public int getPort() {
        return this.datagramChannel.socket().getLocalPort();
    }

    protected synchronized int receive(ByteBuffer buffer) throws IOException {
        if (this.cacheBuffer.position() > 0 && this.cacheBuffer.hasRemaining()) {
            buffer.put(this.cacheBuffer);
            return buffer.position();
        }
        byte[] data = new byte[buffer.limit()];
        this.cacheBuffer.clear();
        SocketAddress address = this.datagramChannel.receive(this.cacheBuffer);
        int size = this.cacheBuffer.position();
        if (address != null) {
            this.cacheBuffer.flip();
            int remaining = this.cacheBuffer.remaining();
            if (remaining > data.length) {
                remaining = data.length;
            }
            this.cacheBuffer.get(data, 0, remaining);
            buffer.put(data, 0, remaining);
            return data.length;
        }
        return size;
    }

    public synchronized void close() throws IOException {
        super.close();
        this.datagramChannel.close();
    }

    protected synchronized void send(ByteBuffer sendBuffer) throws IOException {
        this.datagramChannel.send(sendBuffer, this.address);
    }
}

