<%
'	*************************************************************
'	* Reads LFS Lapper PB.txt and feeds content into a database *
'	*************************************************************
'	To use this ASP page, you will need the following:
'		1) A connection string to connect to your database.
'		2) A database table with the following structure. Default
'		values should do (untested)
'			RecordID, Text, key, no duplicates
'			Username, Text
'			PlyName, Text
'			TotLaps, Numeric
'			LastDate, Text
'			LastTime, Text
'			Car, Text
'			LapTime, Text
'			Track, Text
'			Split1, Text
'			Split2, Text
'			Split3, Text
'			Split4, Text
'			Split5, Text
'			Split6, Text
'			Split7, Text
'		3) The full path to your PB.txt file, or its location in
'		your website directory.
'	*************************************************************


Application("dbConnHold")=true
' Don't allow other pages to query the database table while Application("dbConnHold")=true
' strFileName = Server.MapPath("/PB.txt") ' Uncomment and correct if PB.txt is available in your website directory.
strFileName = "C:\PathTo\YourLapper\PB.txt"

Set objFSO = Server.CreateObject("Scripting.FileSystemObject")
Set TS = objFSO.OpenTextFile(strFileName, 1, False)

DitchContent=DoSQLCommand("DELETE FROM database.Table") ' Wipe the existing data from the database, ready to read in new content.

If DitchContent <> True Then
	Response.Write("Database connection problem. Operation cancelled.")
	Application("dbConnHold")=false	' Release the database table for reading by other pages.
	Response.End()
End If

If Not TS.AtEndOfStream  Then
	NotUsed	=	TS.ReadLine ' Ditch the first line. It's not part of the driver records.
	Do While Not TS.AtendOfStream
		' Read each record block into memory. Since we know the uniform structure of records in PB.txt, we can uniformly read in the correct number of lines in a cycle.
		Username	=	TS.ReadLine
		PlyName		=	TS.ReadLine
		TotLaps		=	TS.ReadLine
		LastDate	=	TS.ReadLine
		LastTime	=	TS.ReadLine
		Car			=	TS.ReadLine
		LapTime		=	TS.ReadLine
		Track		=	TS.ReadLine
		Split1		=	TS.ReadLine
		Split2		=	TS.ReadLine
		Split3		=	TS.ReadLine
		Split4		=	TS.ReadLine
		Split5		=	TS.ReadLine
		Split6		=	TS.ReadLine
		Split7		=	TS.ReadLine
		RecordID	=	Username & ":" & Track & ":" & Car
		
		If Username <> "" Then ' No username error
			' Place the record into the database.
			AddUser=DoSQLCommand("INSERT INTO database.Table VALUES('" & RecordID & "','" & Username & "','" & PlyName &"','" & TotLaps & "','" & LastDate & "','" & LastTime & "','" & Car & "','" & LapTime & "','" & Track & "','" & Split1 & "','" & Split2 & "','" & Split3 & "','" & Split4 & "','" & Split5 & "','" & Split6 & "','" & Split7 "')")
			If AddUser <> True Then
				Response.Write("Could not add user information. Operation cancelled.")
				Application("dbConnHold")=false	' Release the database table for reading by other pages.
				Response.End()
			End If
		End If
	Loop
Else
	Response.Write("Cannot access PB.txt or PB.txt is empty. Operation cancelled.")
	Application("dbConnHold")=false	' Release the database table for reading by other pages.
	Response.End()
End If ' Not TS.AtEndOfStream
TS.Close 
Set TS = Nothing
Set objFSO = Nothing
Application("dbConnHold")=false	' Release the database table for reading by other pages.
Response.Redirect(Request.ServerVariables("HTTP_REFERER"))

Function DoSQLCommand(SQLCommand)
	Set DoSQL_cmd = Server.CreateObject ("ADODB.Command")
	DoSQL_cmd.ActiveConnection = strConnectionString
	DoSQL_cmd.CommandText = SQLCommand
	DoSQL_cmd.Prepared = true
	
	On Error Resume Next
	Set DoSQL = DoSQL_cmd.Execute
	DoSQL_numRows = 0
	
'	Handle any errors
	If Err.Number <> 0 Then
		DoSQLCommand = Err.Number & " - " & Err.Description
		Err.Clear
	Else
		DoSQLCommand = true
	End If
	
	DoSQL.Close()
	Set DoSQL = Nothing
End Function
%>