// reading a complete binary file
#include <iostream>
#include <fstream>
using namespace std;

ifstream::pos_type size;
char * memblock;

int i = 0;

struct StaticWheelInfo {
public:
	float X, Y, Z, Radius, Width;
	float SuspensionTravel;
	struct _TireType {
		unsigned int a: 32;
		unsigned int b: 8;
		unsigned int type : 8;
		unsigned int c: 16;
		const char * ToString () {
			switch(type) {
				case 0: return "RACE R1";
				case 1: return "RACE R2";
				case 2: return "RACE R3";
				case 3: return "RACE R4";
				case 4: return "ROAD SUPER";
				case 5: return "ROAD NORMAL";
				case 6: return "HYBRID";
				case 7: return "KNOBBLY";
			}
			return "???";
		};
	} TireType;
	float SuspensionStiffness, BumpDamping, ReboundDamping, MaxBrakeTorque;
	char zzz[80];
};

int main (int argc, char ** argv) {
	char filename[1024];
	printf("LFS Hotlap RAF File Setting Dumper by AzN_devil & timurrrr\n");

	if (argc > 1) {
		strcpy_s(filename, argv[1]);
	} else {
		printf("File name: ");
		scanf("%s", &filename);
	}

	ifstream file (filename, ios::in|ios::binary|ios::ate);
	if (file.is_open())
	{	
		size = file.tellg();
		cout << "File size: " << size << " bytes";
		memblock = new char [size];
		file.seekg (0, ios::beg);
		file.read (memblock, size);

		file.close();

		/* Check File */
		if (memblock[0]!='L' && memblock[1]!='S' && memblock[2]!='F' && memblock[3]!='R' &&
			memblock[4]!='A' && memblock[5]!='F' && memblock[15]==1) {
				printf("File Error/Not A Hotlap!");
		}
		else {
			// Basic
			printf("\n--------File Info--------\n");
			printf("LFS Version: ");
			for (i=160; i < 168; i++){ printf("%c",memblock[i]); }
			printf("\n");

			printf("Player: ");
			for (i=32; i < 64; i++){ printf("%c",memblock[i]); }
			printf("\n");

			printf("Car: ");
			for (i=64; i < 96; i++){ printf("%c",memblock[i]); }
			printf("\n");

			printf("Track: ");
			for (i=24; i < 28; i++){ printf("%c",memblock[i]); }
			printf("\n");

			printf("Weather: ");
			for (i=144; i < 160; i++){ printf("%c",memblock[i]); }
			printf("\n");

			StaticWheelInfo * wheels = (StaticWheelInfo *)(memblock + 512);
			int front_wheel_idx = -1, rear_wheel_idx = -1;
			for (i = 0; i < 4; i++) {
				if (wheels[i].Y < 0)
					rear_wheel_idx = i;
				else
					front_wheel_idx = i;
			}

			if (front_wheel_idx == -1 || rear_wheel_idx == -1) {
				cout << "Error: can't figure out what tires are front/rear :-)\n";
				delete[] memblock;
				system("PAUSE");
				return 1;
			}

			StaticWheelInfo FrontWheel = wheels[front_wheel_idx], RearWheel = wheels[rear_wheel_idx];

			// Rear
			printf("\n--------Rear Suspension---------\n");
			float rear_antiroll  = *(float*)(memblock + 196);
			float front_antiroll = *(float*)(memblock + 200);

			printf("Motion Range:	 %.3f	m\n",		RearWheel.SuspensionTravel);
			printf("Stiffness:	 %.1f	N/mm\n",		RearWheel.SuspensionStiffness/1000.0f);
			printf("Bump Damping:	 %.1f	Ns/mm\n",	RearWheel.BumpDamping/1000.0f);
			printf("Rebound Damping: %.1f	Ns/mm\n",	RearWheel.ReboundDamping/1000.0f);
			printf("Anti Roll:	 %.1f	N/mm\n",		rear_antiroll/1000.0f);
			printf("Rear Tire Type:  %s\n",			RearWheel.TireType.ToString());


			printf("\n--------Front Suspension--------\n");
			printf("Motion Range:	 %.3f	m\n",		FrontWheel.SuspensionTravel);
			printf("Stiffness:	 %.1f	N/mm\n",		FrontWheel.SuspensionStiffness/1000.0f);
			printf("Bump Damping:	 %.1f	Ns/mm\n",	FrontWheel.BumpDamping/1000.0f);
			printf("Rebound Damping: %.1f	Ns/mm\n",	FrontWheel.ReboundDamping/1000.0f);
			printf("Anti Roll:	 %.1f	N/mm\n",		front_antiroll/1000.0f);
			printf("Front Tire Type: %s\n",			FrontWheel.TireType.ToString());

			printf("\n--------Brakes------------------\n");
			float MaxPerWheelTorque = (FrontWheel.MaxBrakeTorque + RearWheel.MaxBrakeTorque) / 2.0f;
			float BrakeBalance = FrontWheel.MaxBrakeTorque / (MaxPerWheelTorque * 2.0f);
			printf("Maximum Per Wheel	%i Nm\n", (int)MaxPerWheelTorque);
			printf("Brake Balance (front)	%i%%\n", (int)(100.0f * BrakeBalance));

			// Gearbox
			printf("\n--------Gearbox ratios----------\n");
			char numberOfGears = memblock[208];
			char *gearStrings[] = {"1st", "2nd", "3rd", "4th", "5th", "6th"};

			for (i = 0; i < numberOfGears && i < 6; i++) {
				float ratio = *(float*)(memblock + 212 + 4*i);
				printf("%s %.3f\n", gearStrings[i], ratio);
			}
			float final_drive = *(float*)(memblock + 204);
			printf("Final drive: %.3f\n", final_drive);

			printf("\n");
		}

		delete[] memblock;
	}
	else cout << "File doesn't exist/Unable to open file\n";
	system("PAUSE");
}