<?php

new Championship('.', $_GET['Championship'], $_GET['Year']);

class Championship {
	function __construct($path, $name, $season) {
		$this->path = $path;
		$this->name = $name;
		$this->season = $season;
		$this->full = "{$path}/{$name}/Season{$season}";

		$this->image = imagecreatefrompng('./background.png');
		$this->color->white = imagecolorallocate($this->image, 255, 255, 255);
		$this->color->black = imagecolorallocate($this->image, 0, 0, 0);
		$this->font = 3;

		$this->Championship();
	}
	function Championship() {
		$this->Cars = self::ParseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Cars.csv");
		$this->Drivers = self::ParseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Drivers.csv");
		$this->Races = self::ParseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Races.csv");
		$this->Points = self::ParseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Points.csv");
		$this->Teams = self::ParseXSVFile("{$this->path}/{$this->name}/Season{$this->season}/Teams.csv");

		foreach ($this->Races as $Race) {
			if (is_dir("{$this->full}/Round{$Race['Id']}")) {
				$this->Rounds[$Race['Id']]['Qual'] = self::ParseXSVFile("{$this->full}/Round{$Race['Id']}/Qual.csv");
				$this->Rounds[$Race['Id']]['Race'] = self::ParseXSVFile("{$this->full}/Round{$Race['Id']}/Race.csv");
				foreach ($this->Rounds[$Race['Id']]['Race'] as $Place) {
					$Points[$Place['No']] += $this->Points[$Place['Pos'] - 1]['Points'];
				}
			}
		}

		arsort($Points);
		$Keys = array_keys($Points);

		$title = "FiA {$this->name} Driver Championship Standings After " . count($this->Rounds). ' Rounds';
		imagestring($this->image, $this->font, (imagesx($this->image) / 2) - ((imagefontwidth($this->font) * strlen($title)) / 2), 6, $title, $this->color->white);
		for ($i = 1; $i <= 8; $i++) {
			if ($i <= 4) {
				$y = 6 + ($i * 25);
				$x = 10;
			} else {
				$y = 6 + ($i * 25) - 100;
				$x = 235;
			}
			imagestring($this->image, $this->font, $x, $y, $i, $this->color->white); // Number
			$x += 20;
			imagestring($this->image, $this->font, $x, $y, $this->GetDriverValById($Keys[$i-1], 'NameLong'), $this->color->black);
			$x += 150;
			imagestring($this->image, $this->font, $x, $y, $Points[$Keys[$i-1]], $this->color->white); // Points
		}
	}
	// SubHelper Methods
	# Driver
	function GetDriverById($id) {
		foreach ($this->Drivers as $Driver) {
			if ($Driver['Id'] == $id) {
				return $Driver;
			}
		}
		return FALSE;
	}
	function GetDriverValById($id, $val) {
		if (($Driver = $this->GetDriverById($id)) !== FALSE) {
			if (isset($Driver[$val])) {
				return $Driver[$val];
			}
		}
		return FALSE;
	}
	# XSV Parser
	function ParseXSVFile($path, $separator = ',', $firstLineIsHeader = TRUE) {
		foreach (file($path) as $line => $data) {
			if ($line == 0 && $firstLineIsHeader) {
				foreach (split($separator, $data) as $Item => $Key)
					$Keys[$Item] = trim($Key);
			} else {
				foreach (split($separator, $data) as $Item => $Val)
					$Data[$Item] = trim($Val);
				if ($firstLineIsHeader)
					$CSV[] = array_combine($Keys, $Data);
			}
		}
		return $CSV;
	}
	function __destruct() {
		imagepng($this->image, "./{$this->name}/{$this->season}.png");
		imagedestroy($this->image);
	}
}

?>