package src;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class GetInfo {
	
	public String[][] names,tracklist;
	public String[] carlist;
	public String cars = "XFG,XRG,XRT,RB4,FXO,LX4,LX6,MRT,UF1,RAC,FZ5,FOX,XFR,UFR,FO8,FXR,XRR,FZR";
	
	private static int SLEEP_TIMER = 3000;
	
	public String track_info;
	
	private BufferedReader in;
	private File name_file = new File("txtfiles/driver_names.pbl");
	private File track_file = new File("txtfiles/server_names.pbl");
	private File track_names_file = new File("txtfiles/track_corrospondance.pbl");
	

	public GetInfo() { 
		tracklist = readTrackNames();
		carlist = cars.split(",");
		names = readNames();
		
	}
	
	public String[] getTrackInfo(String name) {
		final String Tname = name;
		
		AccessController.doPrivileged(new PrivilegedAction() {
			public Object run() {
				String track_info = "", line = "";
				try {
					URL url = new URL("http://www.lfsworld.net/pubstat/get_stat2.php?action=pb&racer="+Tname);
					url.openConnection();
					in = new BufferedReader(new InputStreamReader((InputStream)url.getContent()));
					while ((line = in.readLine()) != null) { track_info += line+"\n"; }
					in.close();
				}
				catch (MalformedURLException ea) { System.out.println(ea); }
				catch (IOException eb) { System.out.println(eb); }
			GetInfo.this.track_info = track_info;
			return null;
			}
		});
		
		try{ Thread.sleep(SLEEP_TIMER); }
		catch (InterruptedException ec) { System.out.println(ec); }
		
		String[] pbs = track_info.split("\n");

		return pbs;
	}

	private String[][] readNames() {
		String output = "", line = "";
		int line_count = 0;
		
		try {
			in = new BufferedReader(new FileReader(name_file));
			while((line = in.readLine()) != null) {
				output += line+"\n";
				line_count++;
			}
			in.close();
		}
			
		catch (FileNotFoundException ec) { System.out.println(ec); }
		catch (IOException ed) { System.out.println(ed); }
		
		String[] drivers = output.split("\n");
		
		String[][] names = new String[drivers.length][2];
		
		for (int i = 0; i < names.length; i++) {
			String[] temp = drivers[i].split(";",2);
			names[i][0] = temp[0];
			names[i][1] = temp[1];
		}
		
		return names;
	}
	
	private String[][] readTrackNames() {
		String line = "", output = "";
		
		try {
			in = new BufferedReader(new FileReader(track_names_file));
			while ((line = in.readLine()) != null) {
				output += line + "\n";
			}
		}
		catch(FileNotFoundException e) { System.out.println(e); }
		catch(IOException eb) { System.out.println(eb); }
		
		String[] track_details = output.split("\n");
		String[][] tracklist = new String[track_details.length][2];
		
		for (int i = 0; i < tracklist.length; i++) {
			String[] temp3 = track_details[i].split(";", 2);
			tracklist[i][0] = temp3[0];
			tracklist[i][1] = temp3[1];
		}
		
		return tracklist;
	}
	
	public String[] getTrackNames(String[] track) {
		
		for (int i = 0; i < track.length; i++) {
			for (int x = 0; x < tracklist.length; x++) {
				if (track[i].matches(tracklist[x][0])) track[i] = tracklist[x][1];
			}
		}
		
		return track;
	}
	
	public String[][] sortPBs(String[][] driver_pb) {
		String[][] sorted = new String[driver_pb.length][2];
		boolean[] found = new boolean[driver_pb.length];
		int quickest = 999999999, sortcount = 0, pos = 0;
		
		for (int i= 0; i < found.length; i++) { found[i] = false; }
		boolean find = true;
		
		while (find) {
			find = false;
			quickest = 999999999;
			pos = 0;
			for (int i = 0; i < driver_pb.length; i++) {
				if (!found[i] && !driver_pb[i][1].matches("NO TIME.") && Integer.parseInt(driver_pb[i][1]) <= quickest) {
					quickest = Integer.parseInt(driver_pb[i][1]);
					pos = i;
					find = true;
				}
			}
			if (find) {
				sorted[sortcount] = driver_pb[pos];
				found[pos] = true;
				sortcount++;
			}
		}
		for (int i = 0; i < found.length; i++) {
			if (!found[i]) { sorted[sortcount] = driver_pb[i]; sortcount++; found[i] = true; }
		}
		return sorted;
	}
	
	public String convertTimes(String PB) {
		String conv = "NO TIME.", milli = "", Ssec = "";
		int sec = 0, min = 0;
		
		if (!PB.matches("NO TIME.")) {
			milli = PB.substring((PB.length()-3),(PB.length()-1));
			sec = Integer.parseInt(PB.substring(0,(PB.length()-3)));
			
			while (sec >= 60) { sec -= 60; min++; }
			
			Ssec = Integer.toString(sec);
			
			if (Ssec.length() == 1) { Ssec = "0" + Ssec; }
			
			conv = min + ":" + Ssec + "." + milli;
		}
		
		
		
		return conv;
	}
}