﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


namespace G_outgauge
{
    public struct IS_ISI
    {
        // Size of Insim initialisation packet
        public const byte size = 44;

        // Packet Type, use ISP_ISI defined in PacketType enums 
        public byte type;

        //ReqI
        public byte ReqI;

        //Zero Byte for Insim Init Packet
        public byte Zero;

        //UDP Port (2 Byte unsigned byte)
        public ushort UDPPort;

        //Bit Flags, set to 0x04 for single player
        public ushort Flags;

        //Sp0 - i don't know, just set to 0!
        public byte Sp0;

        //Special host message prefix character
        public char Prefix;

        //Time in ms between NLP or MCI
        public ushort Interval;

        //Admin password (if set)
        public string Admin;

        //Short name for the program
        public string IName;

   
// This method marshals all the Insim parameters into a byte packet
     public byte [] initPacket() 
     {
        //create an array for the Insim Initialisation packet
         byte[] data = new byte[size];
    
         //size of packet
         data[0] = size;

         //packet type 
         data[1] = type;

         //ReqI
         data[2] = ReqI;

        //zero value packet
        data[3] = 0;

        //UDP Port
         data[4] = BitConverter.GetBytes(UDPPort)[0];
         data[5] = BitConverter.GetBytes(UDPPort)[1];

         //flags
         data[6] = BitConverter.GetBytes(Flags)[0];
         data[7] = BitConverter.GetBytes(Flags)[1];
         
         //Sp0 - Set value to 0
         data[8] = 0;

         //prefix
         data[9] = (byte)Prefix;

         //interval
         data[10] = BitConverter.GetBytes(Interval)[0];
         data[11] = BitConverter.GetBytes(Interval)[1];

         ASCIIEncoding.ASCII.GetBytes(Admin, 0, Admin.Length, data, 12);
         ASCIIEncoding.ASCII.GetBytes(IName, 0, IName.Length, data, 28);

         data[43] = 0;
        
        
         return data;
         }

    }
}
