<?php

function PIE_settings()
  {
    return array('flags'              => ISF_LOCAL | ISF_MCI | ISF_CON,
                 'insimname'          => 'OnionRadar',
                 'positioninterval'   => 100); // 500 = 2hz, 100 = 10hz, 50 = 20hz
  }
  
function PIE_start()
  {
    $PIE = PIE::connect();
    
    // user settings:
    // detection:
    $PIE->set('shortrange',       35); // metres, drawn on radar
    $PIE->set('longrange',        250); // metres, marked around edge
        
    // display:
    $PIE->set('panelbackground',  true); // dark-button background 
    $PIE->set('contactflash',     0.5); // flash on contact, duration in seconds, 0 = off
    
    // (scaling depends on your resolution, so you can size/scale
    // freely here to adjust. Insim coordinate ranges are integers
    // from 0-200, measured from top and left.)
        
    // AONIO-ish position/scale
    $PIE->set('paneltop',         110);
    $PIE->set('panelleft',        36);
    $PIE->set('panelwidth',       30);
    $PIE->set('panelheight',      50);
    $PIE->set('dotwidth',         2);    
    $PIE->set('dotheight',        3);
    
    /*/
    // LFSLazy-ish position/scale
    $PIE->set('paneltop',         30);
    $PIE->set('panelleft',        115);
    $PIE->set('panelwidth',       50);
    $PIE->set('panelheight',      75);
    $PIE->set('dotwidth',         4);    
    $PIE->set('dotheight',        5);
    //*/
    
    // colours
    $PIE->set('colourself',       '^2'); // green - you
    $PIE->set('colourshort',      '^7'); // white - short range 
    $PIE->set('colourlong',       '^6'); // cyan - long range
    $PIE->set('colourlapup',      '^4'); // blue - higher lapcount than you
    $PIE->set('colourlapdown',    '^1'); // red - lower lapcount than you
    $PIE->set('colouryellowflag', '^3'); // yellow - causing yellow flag  
    $PIE->set('colourlag',        '^5'); // purple - lagging
    $PIE->set('colourcontact',    '^0'); // black - contact
    
    // misc
    $PIE->set('forceclear',       10); // WIP HACK! forces clear every x seconds to defeat persisting dots bug
    $PIE->set('panelclickid',     150);  // max 200 (requires MAXCARS + 1 spaces)
    $PIE->set('lastSTA',          array()); 
    $PIE->set('drawlist',         array()); // people in pit screens can persist in MCI data with coords 0,0
    $PIE->set('contactlist',      array()); // track player contact to highlight
    $PIE->set('hidepanel',        false);   // panel must be hidden in gridding screens, else players can't set 'ready'
    
    PIE_saylocal('OnionRadar');
  }
  
function PIE_clock($t) // WIP HACK! forces clear every x seconds to defeat persisting dots bug
  {
    $PIE = PIE::connect();
    
    $fc = $PIE->get('forceclear');
    $hp = $PIE->get('hidepanel');
    if ($fc && !$hp && !($t%$fc))
      clearall();
  }
  
function PIE_NPL($data) // player joins track
  {
    if (!$data['NumP']) // ignore join req, packet will reccur if request approved
      return; 
    
    // add to drawlist
    $PIE = PIE::connect();
    $PIE->seta('drawlist', $data['PLID'], true);
  }
 
function PIE_PLP($data) // player pits (pitscreen; can persist in MCI with dummy coords)
  {
    // remove from drawlist
    $PIE = PIE::connect();
    $PIE->seta('drawlist', $data['PLID'], false);
  }
 
function PIE_CON($data) // contact
  {
    $PIE = PIE::connect();
    $flashtime = $PIE->get('contactflash');
    
    if (!$flashtime)
      return;
    
    // log plids and time for highlighting
    $plid1 = $data['A']['PLID'];
    $plid2 = $data['B']['PLID'];
    
    $flashend = microtime(true) + $flashtime;
    $PIE->seta('contactlist', $plid1, $flashend);
    $PIE->seta('contactlist', $plid2, $flashend);
  }
    
function PIE_STA($data) // game state change, clear radar in gridding screens
  {
    $PIE = PIE::connect();
    $last = $PIE->get('lastSTA');
    $PIE->set('lastSTA', $data);
    
    if (empty($last))
      $last = $data;
    
    $lastf = $last['Flags'];
    $currentf = $data['Flags'];
    
    // clear dots changing viewed car (why do these sometimes persist? >:( the whole range is cleared with each redraw!)
    if ($last['ViewPLID'] != $data['ViewPLID'])
      clearpanel();
    
    // clear completely & hide when: 
    if ( (!$data['NumP'])                                 // no cars on track
      || (!($currentf & ISS_GAME) && ($lastf & ISS_GAME)) // gridding screen #1 (?)
      || (!$data['RaceInProg'] && $last['RaceInProg']) )  // gridding screen #2 (/end)
      {
        $PIE->set('hidepanel', true);
        clearall(); // this clears even buggily-persisting buttons
      }    
    
    // stop hiding when:
    if ($data['NumP'] && ($currentf & ISS_GAME) && $data['RaceInProg'])
      $PIE->set('hidepanel', false);
  }
  
function PIE_MCI() // update radar panel with each MCI update, when in suitable screen
  {
    $PIE = PIE::connect();  
    
    if ($PIE->get('hidepanel'))
      return;
    
    drawpanel();
  }
    
function clearpanelbg()
  {
    $PIE = PIE::connect();  
    
    $cid = $PIE->get('panelclickid');
    $packet = array('Type'     => ISP_BFN,
                    'SubT'     => BFN_DEL_BTN,
                    'ClickID'  => $cid); 
    PIE_sendpacket($packet); 
  }
  
function clearpanel()
  {
    $PIE = PIE::connect();  
    
    $cid = $PIE->get('panelclickid');
    $packet = array('Type'     => ISP_BFN,
                    'SubT'     => BFN_DEL_BTN,
                    'ClickID'  => $cid+1,
                    'MaxID'    => $cid+1+40); //max 40 plids
    PIE_sendpacket($packet);    
  }
  
function clearall() // force clear all buttons from this insim
  {
    $packet = array('Type'     => ISP_BFN,
                    'SubT'     => BFN_CLEAR);
    PIE_sendpacket($packet);    
  }
  
function drawpanelbg()
  {
    $PIE = PIE::connect();
    
    if (!$PIE->get('panelbackground'))
      return;  
    
    $cid    = $PIE->get('panelclickid');
    $top    = $PIE->get('paneltop');
    $left   = $PIE->get('panelleft');
    $width  = $PIE->get('panelwidth');
    $height = $PIE->get('panelheight');    
    $packet = array('Type'     => ISP_BTN,
                    'ClickID'  => $cid,
                    'BStyle'   => ISB_DARK,
                    'T'        => $top,
                    'L'        => $left,
                    'W'        => $width,
                    'H'        => $height,
                    'Text'     => ' ');                    
    PIE_sendpacket($packet);
  }
  
function drawpanel()
  {
    clearpanel(); // clear everything except background
    
    $PIE = PIE::connect();
    
    $hide = $PIE->get('hidepanel');    
    $plid = $PIE->get('PIE_STA', 'ViewPLID');
    
    if (!$plid || $hide)
      {
        clearpanelbg();
        return;
      }
    
    // skip if we're in MPR and too fast a replay
    if ($PIE->get('PIE_STA', 'ReplaySpeed') > 2)
      return;
    
    $cid        = $PIE->get('panelclickid');
    $top        = $PIE->get('paneltop');
    $left       = $PIE->get('panelleft');
    $width      = $PIE->get('panelwidth');
    $height     = $PIE->get('panelheight');    
    $dotw       = $PIE->get('dotwidth');    
    $doth       = $PIE->get('dotheight');    
    $centrey    = $top + round($height / 2);
    $centrex    = $left + round($width / 2);
    $rl         = $PIE->get('longrange');
    $rs         = $PIE->get('shortrange');    
    $cself      = $PIE->get('colourself');
    $cshort     = $PIE->get('colourshort');
    $clong      = $PIE->get('colourlong');
    $clapup     = $PIE->get('colourlapup');
    $clapdown   = $PIE->get('colourlapdown');
    $cyellow    = $PIE->get('colouryellowflag');
    $clag       = $PIE->get('colourlag');
    $ccontact   = $PIE->get('colourcontact');
    
    // background panel
    drawpanelbg();
    $cid++; 
    
    // fetch MCI/self data
    $MCI  = $PIE->get('PIE_MCI');
    if (empty($MCI))
      return;
    if (empty($MCI[$plid]))
      return;
    $self = $MCI[$plid];    
    $sh = $self['Heading'];
    $shr = deg2rad(($sh/65536)*360); // convert to rads
    
    // check/draw everyone in range
    $contact = false;
    foreach($MCI as $k=>$v)
      {
        // skip self (until after loop, draw last)
        if ($k == $plid) 
          continue;
        
        // skip 'pit screen ghosts'
        if (empty($PIE->get('drawlist', $k)))
          continue;
        
        // skip out-of-range
        $rlr = $rl * 65536; // long range in raw MCI units for coarse check
        $dx = $v['X'] - $self['X'];
        $dy = $v['Y'] - $self['Y'];
        if ((abs($dx) > $rlr) || (abs($dy) > $rlr))
          continue;
        
        $dist = pow((pow(abs($dx), 2) + pow(abs($dy), 2)), 0.5);
        $dist /= 65536; // MCI to metres;
        if ($dist > $rl) // long range in metres for fine check
          continue;
        
        // split ranges (flag and truncate long range blips)
        $short  = ($dist < $rs);
        $dist   = min($rs, $dist);
        
        // heading, rads
        $h = atan2($dy, $dx);  // !!! it is SUPPOSED to be Y before X. (Thanks atan2, I love you too)
        $h += deg2rad(90); // atan2 0 is east, we need north. (This one is fair enough)
        $h -= $shr; // rotate $h to relative to our view
        
        // delta heading, if we want to upgrade this to arrows showing direction
        // $dhr = $shr - deg2rad(($v['Heading']/65536)*360);
        
        // radar position, scaling with user settings
        $xscale = ($dist / $rs) * floor($width/2) * 0.9;
        $yscale = ($dist / $rs) * floor($height/2) * 0.9;        
        $x = floor($left+($width/2)+(sin($h)*$xscale));
        $y = floor($top+($height/2)+(cos($h)*$yscale));
        
        // colour switch cascade, order for priority:
        // long range:
        $colour = $clong; 
        
        //short range 
        if ($short)
          $colour = $cshort;
            
        // blue flag (use lapcount instead of flag packet! flag packet can be delayed, won't show s/f line crossing)
        if ($v['Lap'] > $self['Lap'])
          $colour = $clapup;
        
        // lapdown warning
        if ($v['Lap'] < $self['Lap'])
          $colour = $clapdown;
        
        // yellow flag 
        if ($v['Info'] & CCI_YELLOW)
          $colour = $cyellow;
        
        // lag 
        if ($v['Info'] & CCI_LAG)
          $colour = $clag;    
        
        // recent contact 
        $flashend = $PIE->get('contactlist', $k);
        if ($flashend && ($flashend > microtime(true)))
          $colour = $ccontact;
        
        // send dot to screen
        $packet = array('Type'     => ISP_BTN,
                        'ClickID'  => $cid++,
                        'BStyle'   => 0,
                        'T'        => $y - round($doth/2),
                        'L'        => $x - round($dotw/2),
                        'W'        => $dotw,
                        'H'        => $doth,
                        'Text'     => $colour.'^S'.chr(168).chr(128));
        PIE_sendpacket($packet);
      }       

    // draw self last to overlap all others
    $colour = $cself;
    $flashend = $PIE->get('contactlist', $plid);
    if ($flashend && ($flashend > microtime(true)))
      $colour = $ccontact;
    $packet = array('Type'     => ISP_BTN,
                    'ClickID'  => $cid++,
                    'BStyle'   => 0,
                    'T'        => $centrey - round(($doth/2)),
                    'L'        => $centrex - round(($dotw/2)),
                    'W'        => $dotw,
                    'H'        => $doth,
                    'Text'     => $colour.'^S'.chr(168).chr(128)); //green
    PIE_sendpacket($packet);
  }