#ifndef _CPANE_H_
#define _CPANE_H_

#include "global.h"
#include "ceventredirector.h"
#include <wx/scrolwin.h>

class cGraph;
class wxRegConfig;

//-----------------------------------------------------------------------------
// Base class for the panes

class cPane : public wxScrolledWindow, public cEventRedirector
{
private:
  bool m_ShouldBeHidden;    // is the pane (supposed to be) hidden?

  void OnKey(wxKeyEvent& event);

  DECLARE_EVENT_TABLE()

protected:

public:
  cPane(wxWindow* parent);
  virtual ~cPane();

  inline bool ShouldBeHidden() const { return m_ShouldBeHidden; }
  inline void SetShouldBeHidden(bool hidden) { m_ShouldBeHidden = hidden; }

  virtual wxSize DoGetBestSize() const { return GetMinSize(); }

  virtual void TranslateTexts() = 0;

  virtual void UpdateAll() {}
  virtual void DoShowLap(cLap* WXUNUSED(lap), bool WXUNUSED(shown)) {}
  virtual void DoSetTrackCursorPos(cGraphView* WXUNUSED(view), float WXUNUSED(distance), bool WXUNUSED(scroll)) {}
  virtual void DoSetTrackSelection(float WXUNUSED(start), float WXUNUSED(end)) {}

  virtual void LoadConfig(wxRegConfig* WXUNUSED(config), const wxString& WXUNUSED(key)) {}
  virtual void SaveConfig(wxRegConfig* WXUNUSED(config), const wxString& WXUNUSED(key)) {}
};

#endif
