#ifndef _CMGR_H_
#define _CMGR_H_

#include "global.h"
#include "clap.h"

class cTrackPath;

//-----------------------------------------------------------------------------
// Controller class for the data model

class cMgr
{
private:
  cMgr();
  static cMgr* s_Mgr;       // the single manager object

  cLapArray m_Laps;         // the laps from loaded RAF files
  lapname_t m_LapNaming;    // how are the lap names constructed?

  wxString m_SmxDir;        // directory containing the PTH files
  cTrackPath* m_TrackPath;  // currently loaded PTH files

  static int Compare(cLap** a, cLap** b);         // for sorting the laps
  void SortLaps() { m_Laps.Sort(cMgr::Compare); } // do the sorting

public:
  static cMgr* GetMgr();
  virtual ~cMgr();

  bool AddLap(cLap* lap, wxString& error);
  bool IsLoaded(const wxString& fileName);
  inline bool IsEmpty() const { return m_Laps.IsEmpty(); }
  inline size_t GetLapCount() const { return m_Laps.GetCount(); }
  inline cLap* GetLap(size_t index) { return &(m_Laps[index]); }
  int FindLap(cLap* lap) const { return m_Laps.Index(*lap); }
  void DeleteLap(cLap* lap);
  void RenameLap(const wxString& oldName, const wxString& newName);

  lapname_t GetLapNaming() { return m_LapNaming; }
  void SetLapNaming(lapname_t naming);

  const wxString& GetTrackName() const { return m_Laps[0].GetFullTrackName(); }
  float GetTrackLength() const { return IsEmpty() ? 1.0f : m_Laps[0].GetTrackLength(); }
  const wxString& GetTrackCode() const { return m_Laps[0].GetTrackCode(); }
  cTrackPath* GetTrackPath() const { return m_TrackPath; }

  const wxString& GetSmxDir() const { return m_SmxDir; }
  void SetSmxDir(const wxString& dir) { m_SmxDir = dir; }

  void ClearAll();
};

#endif
