#include "ctrack.h"

//-----------------------------------------------------------------------------
// Static members

wxString cTrack::s_TrackCodes[] = {
 _T("GP Track:BL1"),
 _T("Rallycross:BL2"),
 _T("Car Park:BL3"),
 _T("Classic:SO1"),
 _T("Sprint Track 1:SO2"),
 _T("Sprint Track 2:SO3"),
 _T("City Long:SO4"),
 _T("Town Course:SO5"),
 _T("Chicane Route:SO6"),
 _T("Club:FE1"),
 _T("Green Track:FE2"),
 _T("Gold Track:FE3"),
 _T("Black Track:FE4"),
 _T("Rallycross:FE5"),
 _T("RallyX Green:FE6"),
 _T("Autocross:AU1"),
 _T("Skid Pad:AU2"),
 _T("Drag Strip:AU3"),
 _T("Eight Lane Drag:AU4"),
 _T("Oval:KY1"),
 _T("National:KY2"),
 _T("GP Long:KY3"),
 _T("International:WE1"),
 _T("Cadet:AS1"),
 _T("Club:AS2"),
 _T("National:AS3"),
 _T("Historic:AS4"),
 _T("Grand Prix:AS5"),
 _T("Grand Touring:AS6"),
 _T("North:AS7")
};

//-----------------------------------------------------------------------------

cTrack::cTrack()
{
}

//-----------------------------------------------------------------------------

cTrack::~cTrack()
{
}

//-----------------------------------------------------------------------------
// Convert the full track+config name to the track code
// - name = track name
// - config = configuration name
// Returns an empty string if not found

wxString cTrack::Name2Code(wxString& name, wxString& config)
{
  wxString abbrev = Name2Abbrev(name); // 2-letter track abbreviation

  // remove "reverse" indicator from config name
  bool reverse = false;
  wxString cfg = config;
  if (cfg.Right(4).CmpNoCase(_T("_REV")) == 0) {
    reverse = true;
    cfg = cfg.Left(config.Length() - 4);
  }

  // search the list
  int count = sizeof(s_TrackCodes) / sizeof(wxString);
  for (int i = 0; i < count; i++) {
    wxString name = s_TrackCodes[i].BeforeFirst(':'); // official config name
    wxString code = s_TrackCodes[i].AfterFirst(':');

    if (code.Left(2) != abbrev) continue; // different track abbreviation
    if (name.Left(cfg.Length()).CmpNoCase(cfg) != 0) continue; // different config name

    // found it
    if (reverse) code += _T("R");

    // canonicalize config name
    config = name;
    if (reverse) config += _T(" (reverse)");

    return code;
  }

  // not found
  return wxEmptyString;
}

//-----------------------------------------------------------------------------
// Get the list of codes
// - codes = list that will be filled with the codes

void cTrack::GetCodes(wxArrayString& codes)
{
  codes.Empty();
  int count = sizeof(s_TrackCodes) / sizeof(wxString);
  for (int i = 0; i < count; i++) {
    codes.Add(s_TrackCodes[i].AfterFirst(':'));
  }
  codes.Sort();
}
