#ifndef _CGRAPHCONTAINER_H_
#define _CGRAPHCONTAINER_H_

#include "global.h"
#include "ceventredirector.h"
#include "cgraph.h"
#include <wx/window.h>
#include <wx/sizer.h>
#include <wx/menu.h>
#include <wx/dynarray.h>

// default sizer-proportion of a graph
#define DEFAULT_PROPORTION 10000

class cGraphView;
WX_DEFINE_ARRAY(cGraphView*, cGraphViewPtrArray);

//-----------------------------------------------------------------------------
// The window containing all graphs

class cGraphContainer : public wxWindow, public cEventRedirector
{
private:
  wxBoxSizer* m_TopSizer;
  cGraphViewPtrArray m_Graphs;  // the graph views

  wxColour m_BorderColour;      // colour for drawing border of spacers
  wxColour m_BackgroundColour;  // colour for drawing background of spacers

  wxMenu m_Context;             // context menu

  bool m_DragMode;              // are we drag-resizing?
  size_t m_DragIndex;           // index of spacer that is being dragged
  wxPoint m_LastDragPos;        // last mouse position during drag

  void TellGraphPositions();

  void OnMouseLeftClick(wxMouseEvent& event);
  void OnMouseLeftRelease(wxMouseEvent& event);
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseEntering(wxMouseEvent& WXUNUSED(event)) { SetCursor(wxCursor(wxCURSOR_SIZENS)); }
  void OnMouseLeaving(wxMouseEvent& WXUNUSED(event)) { SetCursor(wxNullCursor); }
  void OnMouseRightClick(wxMouseEvent& event);
  void OnMenuClick(wxCommandEvent& event);
  void OnPaint(wxPaintEvent& event);
  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cGraphContainer(wxWindow* parent, wxColour border, wxColour background);
  virtual ~cGraphContainer();

  cGraphView* AddGraph(graph_t type, const wxString& settings = wxEmptyString, int size = DEFAULT_PROPORTION);
  void DeleteGraph(cGraphView* view);

  size_t GetCount() const { return m_Graphs.GetCount(); }
  cGraphView* GetGraph(size_t index) { return m_Graphs[index]; }
  int Index(wxWindow* window) const { return m_Graphs.Index((cGraphView*)window); }

  int GetProportion(size_t index) const;
  void SetProportion(size_t index, int proportion);

  void EnableToolTips(bool flag);

  void EqualHeight();
  void MoveGraph(cGraphView* view, int change);

  virtual void TranslateTexts();
};

#endif
