#include "cdde.h"

//-----------------------------------------------------------------------------

cDDEServer::cDDEServer()
: wxDDEServer()
{
}

cDDEServer::~cDDEServer()
{
}

wxConnectionBase* cDDEServer::OnAcceptConnection(const wxString& topic)
{
  if (topic != DDE_TOPIC_OPENFILE) return NULL; // unknown topic

  return new cDDEConnection();
}

//-----------------------------------------------------------------------------

cDDEConnection::cDDEConnection()
: wxDDEConnection()
{
}

cDDEConnection::~cDDEConnection()
{
}

bool cDDEConnection::OnExecute(const wxString& topic, char* data, int size, wxIPCFormat WXUNUSED(format))
{
  if (topic != DDE_TOPIC_OPENFILE) return false; // unknown topic

  // send an event to open the file
  wxString filename(data, size);
  ::OpenFile_Send(filename);
  wxLogDebug(_T("DDE open file: %s"), filename.c_str());

  return true;
}
