#ifndef _CLANG_H_
#define _CLANG_H_

#include <wx/string.h>
#include <wx/arrstr.h>

// the start value of IDs
#define LANG_START_ID 100

// the maximum number of logtypes and wheeltypes
#define MAX_LOGTYPES 30
#define MAX_WHEELTYPES 20

// the maximum number of presets
#define MAX_PRESETS 100

// the maximum number of languages
#define MAX_LANGUAGES 100

// macro for translating a string
#define _TT(id, string) cLang::TranslateText(id, _T(string))

class wxMenu;

//-----------------------------------------------------------------------------
// Menu identifiers and other translatable strings

enum ENUM_STRING_IDS
{
  ID_MENU_FIRST = LANG_START_ID,

  // ----- menu items

  // cMainFrame
  ID_MENU_FILE,
  ID_MENU_OPEN,
  ID_MENU_ADD,
  ID_MENU_OPENRECENT,
  ID_MENU_CLOSEALL,
  ID_MENU_EXIT,

  ID_MENU_VIEW,
  ID_MENU_ADDGRAPH_Y,
  ID_MENU_ADDGRAPH_XY,
  ID_MENU_ADDGRAPH_H,
  ID_MENU_PANES,

  ID_MENU_VIEWFLAG_FIRST,
  ID_MENU_LEGEND,
  ID_MENU_TRACKMAP,
  ID_MENU_DRIVINGLINE,
  ID_MENU_PROPERTIES,
  ID_MENU_LOG,
  ID_MENU_CROSSHAIR,
  ID_MENU_FULLSCREEN,
  ID_MENU_VIEWFLAG_LAST,

  ID_MENU_ZOOM,
  ID_MENU_ZOOM_RESET,
  ID_MENU_ZOOM_RESET_ALL,
  ID_MENU_ZOOM_FIT,

  ID_MENU_PRESETS,
  ID_MENU_ADD_PRESET,
  ID_MENU_DELETE_PRESET,
  ID_MENU_PRESET_TOOLBAR,

  ID_MENU_OPTIONS,
  ID_MENU_OPTIONS_FIRST,
  ID_MENU_UNITS,
  ID_MENU_SPEED_KMH,
  ID_MENU_SPEED_MPH,
  ID_MENU_XRULERS,
  ID_MENU_TOOLTIPS,
  ID_MENU_STATUSBAR,
  ID_MENU_CUSTOM_FILE_DLG,
  ID_MENU_SESSION,
  ID_MENU_LANGUAGE,
  ID_MENU_OPTIONS_LAST,

  ID_MENU_HELP,
  ID_MENU_HELP_FIRST,
  ID_MENU_MANUAL,
  ID_MENU_ABOUT,
  ID_MENU_WEBSITE,
  ID_MENU_HELP_LAST,

  // cTrackmap
  ID_MENU_SHOWDISTANCE,
  ID_MENU_SHOWSECTORBUTTONS,
  ID_MENU_SECTOR_ADD_DEL,
  ID_MENU_SECTOR_ADD_SELECTION,
  ID_MENU_SECTOR_RESET,
  ID_MENU_SECTOR_RESET_CLEAR,
  ID_MENU_SECTOR_RESET_TIMELINES,
  ID_MENU_SECTOR_LOCK,

  // cLegend
  ID_MENU_HIDE_LAP,
  ID_MENU_CLOSE_LAP,
  ID_MENU_SHOW_ALL,
  ID_MENU_HIDE_OTHERS,
  ID_MENU_CLOSE_OTHERS,
  ID_MENU_DASHBOARD,
  ID_MENU_LAPNAME,
  ID_MENU_LAPNAME_FILE,
  ID_MENU_LAPNAME_TIME,
  ID_MENU_LAPNAME_TIME_DRIVER,
  ID_MENU_LAPNAME_TIME_CAR_DRIVER,
  ID_MENU_SHOW_LAP,

  // cGraph
  ID_MENU_ZOOM_RESET_Y,
  ID_MENU_FIT,
  ID_MENU_EQUAL_HEIGHT,
  ID_MENU_MOVE_UP,
  ID_MENU_MOVE_DOWN,
  ID_MENU_CLOSE_GRAPH,

  // cDrivingline
  ID_MENU_ZOOM_IN,
  ID_MENU_ZOOM_OUT,
  ID_MENU_AUTOSCROLL,

  // cFileDlg
  ID_MENU_RENAME,
  ID_MENU_DELETE,
  ID_MENU_SELECTALL,

  // ----- pane and dialog captions
  ID_CAPTION_LEGEND,
  ID_CAPTION_TRACKMAP,
  ID_CAPTION_DRIVINGLINE,
  ID_CAPTION_PROPERTIES,
  ID_CAPTION_MESSAGES,
  ID_CAPTION_FILEDLG,

  // ----- other strings

  // cRuler
  ID_TXT_RL_UNITS,

  // cLegend
  ID_TXT_LG_SHOW_LAP,
  ID_TXT_LG_FILE,
  ID_TXT_LG_GRAPH,
  ID_TXT_LG_STEER,
  ID_TXT_LG_PEDALS,
  ID_TXT_LG_GEAR,
  ID_TXT_LG_SPEED,

  // cProperties
  ID_TXT_PR_PLAYERNAME,
  ID_TXT_PR_CARNAME,
  ID_TXT_PR_LAPTIME,
  ID_TXT_PR_SPLITS,
  ID_TXT_PR_SECTORS,
  ID_TXT_PR_LFSVERSION,
  ID_TXT_PR_DRIVERAIDS,
  ID_TXT_PR_HLVC,
  ID_TXT_PR_BRAKES,
  ID_TXT_PR_RIDEHEIGHT,
  ID_TXT_PR_STIFFNESS,
  ID_TXT_PR_DAMPING_BUMP,
  ID_TXT_PR_DAMPING_REBOUND,
  ID_TXT_PR_ANTIROLL,
  ID_TXT_PR_GEARS,
  ID_TXT_PR_FINALDRIVE,
  ID_TXT_PR_TYRETYPE,
  ID_TXT_PR_TYRETEMP,
  ID_TXT_PR_FRONT,
  ID_TXT_PR_REAR,
  ID_TXT_PR_HLVC0,
  ID_TXT_PR_HLVC1,
  ID_TXT_PR_HLVC2,

  // cTrackmap
  ID_TXT_TM_ALL_SECTORS,
  ID_TXT_TM_DEL_SECTOR,

  // cFileDlg
  ID_TXT_FD_FILENAME,
  ID_TXT_FD_CARCODE,
  ID_TXT_FD_TRACKCODE,
  ID_TXT_FD_LAPTIME,
  ID_TXT_FD_DATE,
  ID_TXT_FD_PLAYER,
  ID_TXT_FD_CAR,
  ID_TXT_FD_TRACK,
  ID_TXT_FD_ADD,
  ID_CTRL_FD_FILE_LIST,
  ID_CTRL_FD_CHOICE_CAR,
  ID_CTRL_FD_CHOICE_TRACK,
  ID_CTRL_FD_FOLDER,
  ID_CTRL_FD_DELETE,
  ID_CTRL_FD_RENAME,
  ID_CTRL_FD_ALL,
  ID_CTRL_FD_OPEN,
  ID_CTRL_FD_CANCEL,
  ID_TXT_FD_FILTER_ALL,
  ID_TXT_FD_SELECT_FOLDER,
  ID_TXT_FD_WARNING,
  ID_TXT_FD_DELETE_ONE,
  ID_TXT_FD_DELETE_MANY,
  ID_TXT_FD_RENAME_PROMPT,
  ID_TXT_FD_RENAME_CAPTION,
  ID_TXT_FD_ERROR,
  ID_TXT_FD_FILE_EXISTS,

  // cGraphTools
  ID_CTRL_GT_FIT,
  ID_CTRL_GT_CLOSE,
  ID_CTRL_GT_LOGTYPE_X,
  ID_CTRL_GT_LOGTYPE_Y,
  ID_CTRL_GT_WHEEL,
  ID_CTRL_GT_DELTA,
  ID_CTRL_GT_LAP,
  ID_CTRL_GT_CONNECT,
  ID_TXT_GT_WHEEL,
  ID_TXT_GT_LAP,

  // log types
  ID_LOG_FIRST,
  ID_LOG_SPEED = ID_LOG_FIRST,
  ID_LOG_TIMEINLAP,
  ID_LOG_RPM,
  ID_LOG_GEAR,
  ID_LOG_STEER,
  ID_LOG_THROTTLE,
  ID_LOG_BRAKE,
  ID_LOG_SLIPRATIO,
  ID_LOG_CAMBER,
  ID_LOG_SUSPTRAVEL,
  ID_LOG_FORCE_LON,
  ID_LOG_FORCE_LAT,
  ID_LOG_TYRELOAD,
  ID_LOG_GLONG,
  ID_LOG_GLAT,
  ID_LOG_GTOTAL,
  ID_LOG_WHEELANGLE,
  ID_LOG_SLIPANGLE,
  ID_LOG_CLUTCH,
  ID_LOG_WHEELSPEED_VERT,
  ID_LOG_WHEELSPEED_ROT,
  ID_LOG_POWER,

  ID_LOG_LAST = ID_LOG_FIRST + MAX_LOGTYPES,

  // wheel types
  ID_WHEEL_FIRST,
  ID_WHEEL_FRONT_LEFT = ID_WHEEL_FIRST,
  ID_WHEEL_FRONT_RIGHT,
  ID_WHEEL_REAR_LEFT,
  ID_WHEEL_REAR_RIGHT,
  ID_WHEEL_AVG,
  ID_WHEEL_AVG_FRONT,
  ID_WHEEL_AVG_REAR,
  ID_WHEEL_MIN,
  ID_WHEEL_MIN_FRONT,
  ID_WHEEL_MIN_REAR,
  ID_WHEEL_MAX,
  ID_WHEEL_MAX_FRONT,
  ID_WHEEL_MAX_REAR,
  ID_WHEEL_DELTA_ALL,
  ID_WHEEL_DELTA_FRONT,
  ID_WHEEL_DELTA_REAR,

  ID_WHEEL_LAST = ID_WHEEL_FIRST + MAX_WHEELTYPES,

  // cMainFrame
  ID_TXT_MF_ADDFILES,
  ID_TXT_MF_OPENFILES,
  ID_TXT_MF_ADDPRESET_CAPTION,
  ID_TXT_MF_ADDPRESET_PROMPT,
  ID_TXT_MF_OVERWRITEPRESET_CAPTION,
  ID_TXT_MF_OVERWRITEPRESET_PROMPT,
  ID_TXT_MF_DELETEPRESET_CAPTION,
  ID_TXT_MF_DELETEPRESET_PROMPT,
  ID_TXT_MF_ERROR,
  ID_TXT_MF_WARNING,
  ID_TXT_MF_STATUS_LOADING,
  ID_TXT_MF_LOADING,
  ID_TXT_MF_ADDING,
  ID_TXT_MF_INCOMPLETELAP,

  // cPresets
  ID_TXT_PRESET_DEFAULT,

  // cLegend - exporting laps
  ID_MENU_LG_EXPORT,
  ID_TXT_LG_EXPORT_CAPTION,
  ID_TXT_LG_EXPORT_WILDCARD,

  // cGraph - exporting graph data
  ID_MENU_GR_EXPORT,
  ID_TXT_GR_EXPORT_CAPTION,
  ID_TXT_GR_EXPORT_WILDCARD,

  // cTrackMap - further sector ops
  ID_MENU_SECTOR_UNDO,
  ID_MENU_SECTOR_AUTODETECT,

  // cMainFrame - hide/show all panes
  ID_MENU_HIDEALLPANES,
  ID_TXT_MF_SHOWALLPANES,

  // ----- new translatable IDs must be added AFTER this

  // ----- after this, we have items that are not translated
  ID_MENU_LAST_TRANSLATABLE,

  ID_MENU_PRESET_FIRST = ID_MENU_FIRST + 1000,
  ID_MENU_PRESET_LAST = ID_MENU_PRESET_FIRST + MAX_PRESETS,

  ID_MENU_LANGUAGE_FIRST,
  ID_MENU_LANGUAGE_LAST = ID_MENU_LANGUAGE_FIRST + MAX_LANGUAGES,

  // end
  ID_MENU_LAST
};

//-----------------------------------------------------------------------------
// Translation of strings into other languages

class cLang
{
private:
  static wxString m_LanguageDir;  // the directory for the language files
  static wxString m_Language;     // the selected language

  static wxArrayString m_DefText; // the strings in the default language
  static wxArrayString m_DefHelp; // the help in the default language

  static wxArrayString m_SelText; // the strings in the user-selected language
  static wxArrayString m_SelHelp; // the help in the user-selected language

  // class only has static members, so ctor and dtor are private
  cLang();
  virtual ~cLang();

  static const wxString& Lookup(int id, const wxString& def, wxArrayString& selArr, wxArrayString& defArr);
  static bool Load(const wxString& name, wxArrayString& txt, wxArrayString& hlp);

public:
  static void SetFolder(const wxString& folder);
  static void GetLanguageList(wxArrayString& list);

  static const wxString& GetLanguage() { return m_Language; }
  static bool SetLanguage(const wxString& name);

  static const wxString& TranslateText(int id, const wxString& def);
  static const wxString& TranslateHelp(int id, const wxString& def);
  static void TranslateMenu(wxMenu* menu);

  static void AppendMenuItem(wxMenu* menu, int id, const wxString& label, const wxString& help = wxEmptyString);
  static void AppendMenuItem(wxMenu* menu, int id, const wxString& label, wxMenu* submenu, const wxString& help = wxEmptyString);
  static void AppendCheckItem(wxMenu* menu, int id, const wxString& label, const wxString& help = wxEmptyString);

  static bool DumpDefault();
};

#endif
