#ifndef _CGRAPH_XY_H_
#define _CGRAPH_XY_H_

#include "global.h"
#include "cgraph.h"
#include <wx/menu.h>

//-----------------------------------------------------------------------------
// A graph

class cGraphXY : public cGraph
{
private:
  void PutTrackCursor(float distance);
  wxRect GetTrackCursorPosition();

  // graph contents
  int m_LogtypeX;          // type of log-data to be shown in the X dimension
  int m_LogtypeY;          // type of log-data to be shown in the Y dimension
  int m_Wheel;             // type of wheel for which the data must be shown

  // event handlers
  void OnMouseMove(wxMouseEvent& event);
  void OnMouseEntering(wxMouseEvent& event);
  void OnMouseLeaving(wxMouseEvent& event);
  void OnPaint(wxPaintEvent& event);

  float DecodeMouse(wxPoint pos);
  virtual void OnMouseClickRelease(wxPoint pos);

  DECLARE_EVENT_TABLE()

protected:
  virtual float GetSelectionStart() { return m_SelStart; }
  virtual float GetSelectionEnd() { return m_SelEnd; }

  virtual rbbmode_t GetRbbMode(wxMouseEvent& event);

public:
  cGraphXY(cGraphView* parent);
  virtual ~cGraphXY();

  // manage the set of curves
  virtual void AddCurve(cLap* lap);
  virtual void DeleteCurve(cLap* lap);
  virtual void DeleteAllCurves();

  virtual bool IsIntegerX() { return cCarState::IsInteger(m_LogtypeX); }
  virtual bool IsIntegerY() { return cCarState::IsInteger(m_LogtypeY); }

  int GetLogtypeX() const { return m_LogtypeX; }
  int GetLogtypeY() const { return m_LogtypeY; }
  int GetWheeltype() const { return m_Wheel; }
  void SetLogtype(int log_x, int log_y, int wheel);

  virtual void DoSetTrackSelection(float start, float end);
  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, bool scroll);

  virtual wxString SaveSettings() const;
  virtual void LoadSettings(const wxString& settings);

  virtual wxString GetUnitsX() { return cCarState::GetLogtypeUnits(m_LogtypeX); }
  virtual wxString GetUnitsY() { return cCarState::GetLogtypeUnits(m_LogtypeY); }
};

#endif
