<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/">
		<html>
			<head>
				<title>
					Server best times at
					<xsl:value-of select="server_best/server/name"/>
				</title>
			</head>
			<!-- <body bgcolor="#DDEEDD"> -->
			<body bgcolor="#000000" text="#ffffff">
				<font face="Verdana, Geneva, Arial, Helvetica, sans-serif" size="4" color="#fffff">
					<br/>
					<br/>
					<h1 align='center'>Server best times</h1>
					<br/>
					<xsl:apply-templates select="server_best">
						<xsl:sort select="entry/lap" order = "ascending" />
					</xsl:apply-templates>
				</font>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="server">
		<!-- <table width="90%" border="0" align="center" cellspacing="3" cellpadding="3" bgcolor="#CCDDCC"> -->
		<table width="90%" border="0" align="center" cellspacing="3" cellpadding="3" bgcolor="#000000">
			<tr>
				<td><b>Server: </b></td>
				<td><xsl:value-of select="name"/></td>
			</tr>
			<tr>
				<td><b>Time: </b></td>
				<td><xsl:value-of select="../time"/></td>
			</tr>
			<tr>
				<td><b>Track: </b></td>
				<td><xsl:value-of select="../track/name"/> (<xsl:value-of select="../track/length"/> meters)</td>
			</tr>
		</table>
		<p></p>
	</xsl:template>

	
	<xsl:template match="server_best">
	
		<xsl:apply-templates select="comment"/>
		<br/>
	
		<xsl:apply-templates select="server"/>
		<br/>
	
		<!-- <table width="90%" border="0" align="center" cellspacing="3" cellpadding="3" bgcolor="#CCDDCC"> -->
		<table width="90%" border="0" align="center" cellspacing="3" cellpadding="3" bgcolor="#000000">
			<tr>
				<td><b>Pos.</b></td>
				<td><b>Driver</b></td>
				<td><b>Car</b></td>
				<td></td> <!-- car picture -->
				<td><b>Lap time</b></td>
				<xsl:if test="number(track/splits) > 0">
					<td><b>Split 1</b></td>
				</xsl:if>
				<xsl:if test="number(track/splits) > 1">
					<td><b>Split 2</b></td>
				</xsl:if>
				<xsl:if test="number(track/splits) > 2">
					<td><b>Split 3</b></td>
				</xsl:if>
				<xsl:if test="number(track/splits) > 3">
					<td><b>Split 4</b></td>
				</xsl:if>
			</tr>
			<xsl:apply-templates select="entry"/>
		</table>

		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
		<br/>
	</xsl:template>
	
	<xsl:template match="comment">
		<table width="90%" border="0" align="center" cellspacing="3" cellpadding="3" bgcolor="#000000">
			<tr>
				<td><xsl:value-of select="."/></td>
			</tr>
		</table>
	</xsl:template>
	
	<xsl:template match="entry">
		<tr>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="position()"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->
					<p valign="center"><xsl:value-of select="position()"/></p>
				<!-- </xsl:if> -->
			</td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="driver"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->
					<!-- <p valign="center"><xsl:value-of select="driver"/></p> -->
					<xsl:value-of select="driver"/>
				<!-- </xsl:if> -->
			</td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="car"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->

				<p valign="center"><xsl:value-of select="car"/></p>
				<!-- </xsl:if> -->
			</td>
			<td>
				<img border="0" width="128" height="64" align="center">
					<xsl:attribute name="src">../pics/s_<xsl:value-of select="car"/>.jpg</xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="car"/></xsl:attribute>
				</img>
			</td>
			<td>
				<!--
				<xsl:if test="position() = 1">
					<font size="5">
						<xsl:value-of select="lap"/>
					</font>
				</xsl:if>
				<xsl:if test="not(position() = 1)">
				-->
					<p avalign="center">
						<xsl:value-of select="lap"/>
						<xsl:if test="average_speed">
							<font size="1">
								<br/>
								(<xsl:value-of select="average_speed"/> km/h)
							</font>
						</xsl:if>
					</p>
				<!-- </xsl:if> -->
			</td>
			
			<!--
			<xsl:apply-templates select="split"/>
			-->

			<xsl:for-each select="split">
				<td>
					<!--
					<xsl:if test="position() = 1">
					 <xsl:if test="../position()=1">
						<font size="5">
							<xsl:value-of select="."/>
						</font>
					</xsl:if>
					<xsl:if test="not(position() = 1)">
					-->
					<!-- <xsl:if test="not(..[1]) = 1)"> -->
						<p avalign="center"><xsl:value-of select="."/></p>
					<!-- </xsl:if> -->
				</td>
			</xsl:for-each>

			
			<!--
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			-->
			<!--
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			<xsl:if test="split">
				<td>
					<xsl:value-of select="split"/>
				</td>
			</xsl:if>
			-->
		</tr>
	</xsl:template>
	<!--
	<xsl:template match="split">
		<td>
			<xsl:if test="../[position() = 1]">
				<font size="5"/>
			</xsl:if> 
			<xsl:value-of select="."/>
			<xsl:if test="../[position() = 1]">
				<font size="4"/>
			</xsl:if>
		</td>	
	</xsl:template>
	-->
</xsl:stylesheet>

