<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
<!-- Simple result stylesheet v.1.0 by: Aquilifer -->

<xsl:output method =  "html"/>

	<xsl:template match="/">
		<!-- <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"/> -->
		<html>
			<head>
				<title>
					Laps at
					<xsl:value-of select="laps/server/name"/>
				</title>
			</head>

			<body bgcolor="#000000" text="#ffffff" background="../pics/bg_race.jpg">
				<font face="Verdana, Geneva, Arial, Helvetica, sans-serif" size="3" color="#fffff">
					<br/>
					<br/>
					<!--  <h1 align='center'>Laps</h1> -->

					<table align="center">
						<tr>
						<td>
						<!-- <img src="../pics/title_race.gif" alt="Race results" halign="center"/> -->
						<h1>Lap data</h1>
						</td>
						</tr>
					</table>

					<br/>

					<!--
					<xsl:apply-templates select="race">
						<xsl:sort select="entry/endtime" order = "ascending" />
					</xsl:apply-templates>
					-->
					<xsl:apply-templates select="laps"/>

					<font size="2"><p align="center">Generated by VCom</p></font>

				</font>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="server">
		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0" bgcolor="#555555">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td width="20%"></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Server: </b></td>
				<!-- <td><xsl:value-of select="name"/></td> -->
				<td>
					<xsl:apply-templates select="name"/>
				</td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Time: </b></td>
				<td><xsl:value-of select="../time"/></td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Track: </b></td>
				<td><xsl:value-of select="../track/name"/> (<xsl:value-of select="../track/length"/> meters)</td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>

		</table>
		<p></p>
	</xsl:template>

	
	<xsl:template match="laps">
	
		<xsl:apply-templates select="comment"/>
		<br/>
	
		<xsl:apply-templates select="server"/>
		<br/>

		<xsl:apply-templates select="player"/>
		<br/>

		<br/>
		<br/>
		<br/>
	</xsl:template>
	
	<xsl:template match="comment">
		<xsl:if test="string-length(.) > 0">
			<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td>
					<td width="12" height="12"></td>
				</tr>
				<tr bgcolor="#555555">
					<td></td>
					<td><xsl:value-of select="."/></td>
					<td></td>
				</tr>
				<tr bgcolor="#555555">
					<td width="12" height="12"></td>
					<td></td>
					<td width="12" height="12"></td>
				</tr>
			</table>
		</xsl:if>
	</xsl:template>
	

	<xsl:template match="player">
		
		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td width="20%"></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Name</b></td>
				<xsl:if test="string-length(uname)=0">
					<!-- <td><xsl:value-of select="pname"/></td> -->
					<td><xsl:apply-templates select="pname"/></td>
				</xsl:if>
				<xsl:if test="string-length(uname)>0">
					<!-- <td><xsl:value-of select="pname"/> <font size="2"> (<xsl:value-of select="uname"/>)</font></td> -->
					<td><xsl:apply-templates select="pname"/> <font size="2"> (<xsl:value-of select="uname"/>)</font></td>
				</xsl:if>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Car</b></td>

				<xsl:if test="handicap_mass=0 and handicap_intake=0">
					<td><xsl:value-of select="car"/></td>
				</xsl:if>

				<xsl:if test="handicap_mass>0 or handicap_intake>0">
					<td><xsl:value-of select="car"/> <font size="2"> (mass +<xsl:value-of select="handicap_mass"/>kg, intake -<xsl:value-of select="handicap_intake"/>%)</font></td>
				</xsl:if>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Best lap</b></td>
				<td><xsl:value-of select="best_lap"/></td>
				<td></td>
			</tr>

			<xsl:apply-templates select="best_split"/>
			<xsl:apply-templates select="best_sector"/>

			<tr bgcolor="#555555">
				<td></td>
				<td><b>Theoretical best</b></td>
				<td><xsl:value-of select="theoretical_best"/></td>
				<td></td>
			</tr>
			<tr bgcolor="#555555">
				<td></td>
				<td><b>Best speedtrap</b></td>
				<td><xsl:value-of select="best_speed"/>kph (<xsl:value-of select="round(best_speed div 1.609344 * 1000) div 1000"/> mph)</td>
				<td></td>
			</tr>

			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td width="20%"></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>


			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
		</table>

		<br/>

		<table width="90%" border="0" align="center" cellspacing="0" cellpadding="0">
			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td width="10%"></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>

			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td width="5%"><b>Laps</b></td>
				<td width="15%"><xsl:value-of select="lapcount"/> (<xsl:value-of select="lapcount * ../track/length div 1000"/>km / <xsl:value-of select="round(lapcount * ../track/length * 100 div 1609.344) div 100"/>mi)</td>
				<td width="15%"><b>Average speed</b></td>
				<td width="15%"><xsl:value-of select="average_speed"/>kph (<xsl:value-of select="round(average_speed div 1.609344 * 1000) div 1000"/>mph)</td>
				<td width="15%"><b>Average lap</b></td>
				<td><xsl:value-of select="average_lap"/></td>
				<td width="12" height="12"></td>
			</tr>

			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td width="10%"><b>#</b></td>
				<td><b>Split 1</b></td>
				<td><b>Split 2</b></td>
				<td><b>Split 3</b></td>
				<td><b>Lap</b></td>
				<td><b>Pit</b></td>
				<td width="12" height="12"></td>
			</tr>

			<xsl:apply-templates select="lap"/>

			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td><b>Total</b></td>
				<td></td>
				<td></td>
				<td></td>
				<td><b><xsl:value-of select="total_time"/></b></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>

			<tr bgcolor="#555555">
				<td width="12" height="12"></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td width="12" height="12"></td>
			</tr>
		</table>
		<br/><br/>
	</xsl:template>

	<xsl:template match="best_split">
		<tr bgcolor="#555555">
			<td></td>
			<td><b>Best split <xsl:value-of select="@number"/></b></td>
			<td><xsl:value-of select="."/></td>
			<td></td>
		</tr>
	</xsl:template>

	<xsl:template match="best_sector">
		<tr bgcolor="#555555">
			<td></td>
			<td><b>Best sector <xsl:value-of select="@number"/></b></td>
			<td><xsl:value-of select="."/></td>
			<td></td>
		</tr>
	</xsl:template>

	<xsl:template match="lap">
		<tr bgcolor="#555555">
			<td></td>
			<td><b><xsl:value-of select="@number"/>.</b></td>
			<!-- <xsl:apply-templates select="split"/> -->
			<td>
				<xsl:if test="split[@number=1 and @best=2]">
					<font color="#ff0000">
					<xsl:value-of select="split[@number=1]"/>
					</font>
				</xsl:if>
				<xsl:if test="split[@number=1 and @best=1]">
					<font color="#ffff00">
					<xsl:value-of select="split[@number=1]"/>
					</font>
				</xsl:if>
				<xsl:if test="split[@number=1 and not(@best)]">
					<xsl:value-of select="split[@number=1]"/>
				</xsl:if>				
			</td>
			<td>
				<xsl:if test="split[@number=2 and @best=2]">
					<font color="#ff0000">
					<xsl:value-of select="split[@number=2]"/>
					</font>
				</xsl:if>
				<xsl:if test="split[@number=2 and @best=1]">
					<font color="#ffff00">
					<xsl:value-of select="split[@number=2]"/>
					</font>
				</xsl:if>
				<xsl:if test="split[@number=2 and not(@best)]">
					<xsl:value-of select="split[@number=2]"/>
				</xsl:if>				

				<!-- <xsl:value-of select="split[@number=2]"/> -->
			</td>
			<td>
				<xsl:if test="split[@number=3 and @best=2]">
					<font color="#ff0000">
					<xsl:value-of select="split[@number=3]"/>
					</font>
				</xsl:if>
				<xsl:if test="split[@number=3 and @best=1]">
					<font color="#ffff00">
					<xsl:value-of select="split[@number=3]"/>
					</font>
				</xsl:if>
				<xsl:if test="split[@number=3 and not(@best)]">
					<xsl:value-of select="split[@number=3]"/>
				</xsl:if>				

				<!-- <xsl:value-of select="split[@number=3]"/> -->
			</td>
			<td>
				<xsl:if test="laptime[@best=2]">
					<font color="#ff0000">
					<xsl:value-of select="laptime"/>
					</font>
				</xsl:if>
				<xsl:if test="laptime[@best=1]">
					<font color="#ffff00">
					<xsl:value-of select="laptime"/>
					</font>
				</xsl:if>
				<xsl:if test="not(laptime[@best])">
					<xsl:value-of select="laptime[not(@best)]"/>
				</xsl:if>				

				<!-- <xsl:value-of select="laptime"/> -->
			</td>
			<td><xsl:value-of select="pittime"/></td>
			<td></td>
		</tr>
	</xsl:template>

	<xsl:template match="split">
		<td><xsl:value-of select="."/></td>
	</xsl:template>

	<xsl:template match="entry">
		<tr bgcolor="#555555">
			<td></td>
			<td>
				<xsl:if test="not(@dqf)">
					<p valign="center"><xsl:value-of select="position()"/></p>
				</xsl:if>
				<xsl:if test="@dqf">
					<p valign="center">DQF<br/>
					<font size="1">(<xsl:value-of select="@dqf"/>)</font></p>
				</xsl:if>
			</td>
			<td>
				<xsl:apply-templates select="name"/>
			</td>
			<td>
				<p valign="center"><xsl:value-of select="car"/></p>
			</td>
			<td>
				<img border="0" width="128" height="64" align="center">
					<!-- <xsl:attribute name="src">../pics/s_<xsl:value-of select="car"/>.jpg</xsl:attribute> -->
				<xsl:attribute name="src">../pics/<xsl:value-of select="car"/>.jpg</xsl:attribute>
					<xsl:attribute name="alt"><xsl:value-of select="car"/></xsl:attribute>
				</img>
			</td>
			<td>
					<p avalign="center">
						<!-- #1 race lenght is hours -->
						<xsl:if test="lapsdone">
							<xsl:value-of select="lapsdone"/> laps
							<font size="2">
								<br/>
								<xsl:value-of select="endtime"/>
							</font>
						</xsl:if>
						<!-- #2 race lenght is laps -->
						<xsl:if test="not(lapsdone)">
							<xsl:value-of select="endtime"/>
						</xsl:if>

						<xsl:if test="time_diff">
							<font size="1">
								<br/>
								(+<xsl:value-of select="time_diff"/>)
							</font>
						</xsl:if>
						<xsl:if test="@timepenalty">
							<font size="1">
								<br/>
								(+<xsl:value-of select="@timepenalty"/> sec penalty)
							</font>					
						</xsl:if>
						<xsl:if test="average_speed">
							<font size="1">
								<br/>
								(<xsl:value-of select="average_speed"/> km/h)
								<br/>
								(<xsl:value-of select="round(average_speed *1000 div 1.609344) div 1000"/> mi/h)
							</font>
						</xsl:if>
					</p>
			</td>
			<td>
				<p avalign="center"><xsl:value-of select="bestlap"/></p>
			</td>
			<td>
				<p avalign="center"><xsl:value-of select="pitstops"/></p>
			</td>
			<td></td>
		</tr>
	</xsl:template>

	<xsl:template match="pname">
		<xsl:if test="font">
			<xsl:apply-templates select="font"/>
		</xsl:if>
		<xsl:if test="not(font)">
			<xsl:value-of select="."/>
		</xsl:if>
	</xsl:template>
		
	<xsl:template match="font">
		<!-- <xsl:attribute name="color"> -->
		<font>
			<xsl:attribute name="color"> <xsl:value-of select="@color"/> </xsl:attribute>
			<xsl:value-of select="."/>
		</font>
	</xsl:template>
</xsl:stylesheet>

