<?php

/*
** @package   PHPOutSim
** @since     2008-03-07 05:58
** @author    Mark 'Dygear' Tomlin.
** @license   MIT License (http://opensource.org/licenses/mit-license.php)
** @copyright Copyright (C) 2008, Mark 'Dygear' Tomlin.
** @version   0.2.1
*/

$OutSim = new OutSim();

class OutSim {
	private $conn;

	function __construct($Address = '127.0.0.1', $Port = 35000) {
		// Socket In;
		if ($this->conn = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP)) {
			echo('Listen socket created!' . PHP_EOL);
			if (socket_bind($this->conn, $Address, $Port))
				echo('Binded to listen socket!' . PHP_EOL);
			else
				die('Could not bind to listen socket, address or port!' . PHP_EOL);
		}
		else
			die('Could not create listen socket!' . PHP_EOL);
		$this->main();
	}
	
	function main() {
		while (TRUE) {
			if ($data = socket_read($this->conn, 256, PHP_BINARY_READ)) {
				print_r(
					unpack(
						'ITime/a4Car/vFlags/CGear/CSpareB/fSpeed/fRPM/fTurbo/fEngTemp/fFuel/fOilPress/fSpare1/fSpare2/fSpare3/fThrottle/fBrake/fClutch/a16Display1/a16Display2',
						$data
					)
				);
			}
		}
	}
	
	function convert_og_flags($bits) {
		$data = array();
		if ($bits & 1)		$data[1]		= 'OG_SHIFTLIGHT';
		if ($bits & 2)		$data[2]		= 'OG_FULLBEAM';
		if ($bits & 4)		$data[4]		= 'OG_HANDBRAKE';
		if ($bits & 8)		$data[8]		= 'OG_PITSPEED';
		if ($bits & 16)		$data[16]		= 'OG_TC';
		if ($bits & 32)		$data[32]		= 'OG_HEADLIGHTS';
		if ($bits & 64)		$data[64]		= 'OG_SIGNAL_L';
		if ($bits & 128)	$data[128]		= 'OG_SIGNAL_R';
		if ($bits & 256)	$data[256]		= 'OG_REDLINE';
		if ($bits & 512)	$data[512]		= 'OG_OILWARN';
		if ($bits & 1024)	$data[1024]		= 'OG_1';
		if ($bits & 2048)	$data[2048]		= 'OG_2';
		if ($bits & 4096)	$data[4096]		= 'OG_3';
		if ($bits & 8192)	$data[8192]		= 'OG_4';
		if ($bits & 16384)	$data[16384]	= 'OG_KM';
		if ($bits & 32768)	$data[32768]	= 'OG_BAR';
		return $data;
	}
	
	function __destruct() {
		socket_close($this->conn);
	}
}

?>