#include <stdio.h>
#include <windows.h>

HINSTANCE hInst;
HWND hWnd;

const char *class_name		= "KB_TEST";
const char *window_name		= "Keyboard Test";

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

void Refresh()
{
	RECT rt;
	GetClientRect(hWnd, &rt);
	InvalidateRgn(hWnd, NULL, TRUE);
	UpdateWindow(hWnd);
}

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WNDCLASS wc;

	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= (WNDPROC)WndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= NULL;
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= class_name;

	if (RegisterClass(&wc)==NULL)
	{
		return 0;
	}

	hInst = hInstance; // store instance handle in global variable

	hWnd = CreateWindowEx
	(
		0,
		class_name,
		window_name,
		WS_OVERLAPPEDWINDOW,
		200,
		80,
		400,	// w
		200,	// h
		NULL,
		NULL,
		hInstance,
		NULL
	);

	if (hWnd==NULL)
	{
		return 0;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	int carry_on = 1; // main message loop
	
	while (carry_on)
	{
		Sleep(50); // give up time to CPU for 50 ms

		MSG msg; // check for windows messages

		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message != WM_QUIT)
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
			else
			{
				carry_on = 0;
			}
		}
	}

	return 0;
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	PAINTSTRUCT ps;
	HDC hdc;

	switch (message) 
	{
	case WM_PAINT:
		{
			hdc = BeginPaint(hWnd, &ps);
			RECT rt;
			GetClientRect(hWnd, &rt);

			//// TEXT START ////

			char buf[256];

			HKL hkl = GetKeyboardLayout(0);

			sprintf(buf, "GetKeyboardLayout : %08X", hkl);
			DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
			rt.top += 20;

			// HERE is a description of the Simplified Chinese IME problem in Windows Vista...

			// In Windows XP, GetKeyboardLayoutName returns a different value depending on the
			// active input method, e.g. US Keyboard / ZhengMa / QuanPin / Microsoft Pinyin IME
			// and the actual name of the input method can be read from the registry (below)

			// In XP this program displays a different value each time you press CTRL + SHIFT - OK!

			// In Windows Vista however, the different Simplified Chinese Input Methods have been
			// unified into a single IME operating in different modes and this causes a problem
			// for a full screen program which must display the name of the active input method

			// In Vista this program displays "Chinese (Simplified) - US Keyboard" in all modes - BAD!

			char k_layout[KL_NAMELENGTH];

			if (GetKeyboardLayoutName(k_layout))
			{
				sprintf(buf, "GetKeyboardLayoutName : %s", k_layout);
				DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
				rt.top += 20;

				const DWORD MAX_IME_NAME = 80;

				HKEY	key;
				char	reg[MAX_PATH];

				sprintf(reg, "SYSTEM\\CurrentControlSet\\Control\\Keyboard Layouts\\%s", k_layout);

				if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, reg, 0, KEY_QUERY_VALUE, &key)==ERROR_SUCCESS) // opened key - now read the Layout Text value
				{
					char IMEName[MAX_IME_NAME];

					DWORD buf_len = MAX_IME_NAME;
					DWORD buf_type;

					if (RegQueryValueEx(key, "Layout Text", NULL, &buf_type, (LPBYTE)IMEName, &buf_len)==ERROR_SUCCESS && buf_type==REG_SZ)
					{
						sprintf(buf, "Layout Text : %s", IMEName); // OK - show the name of the active input method (or keyboard layout)
					}
					else // show an error message
					{
						strcpy(buf, "No Layout Text");
					}

					DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
					rt.top += 20;

					RegCloseKey(key); // close key
				}
				else // failed to open registry key
				{
					sprintf(buf, "No Layout Text : %08X (%s)", hkl, k_layout);
					DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
					rt.top += 20;
				}
			}
			else // failed to get keyboard layout name
			{
				strcpy(buf, "GetKeyboardLayoutName failed");
				DrawText(hdc, buf, strlen(buf), &rt, DT_CENTER);
				rt.top += 20;
			}

			//// TEXT END ////

			EndPaint(hWnd, &ps);
		}
		break;

	case WM_DESTROY:
		PostQuitMessage(0); // exit
		break;

	case WM_CHAR:
		if (wParam==VK_ESCAPE) // ESC - exit
		{
			PostQuitMessage(0);
		}
		else // any key other than ESC - redraw the screen
		{
			Refresh();
		}
		break;

	case WM_INPUTLANGCHANGE: // language message - set screen to be redrawn and call DefWindowProc
	case WM_IME_NOTIFY:
		Refresh();
		return DefWindowProc(hWnd, message, wParam, lParam);

	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}

   return 0;
}