/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Driver;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.EventListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import it.starblue.LFS.LFSNextRace.Screens.TrackerScreen;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class UnregistrationScreen
implements Screen {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Screens.UnregistrationScreen");
    private static final int OKBUTTON = 20;
    private static final int CANCELBUTTON = 21;
    private HashMap<Byte, String> carMapping = new HashMap();
    private Connection connection;
    private Event event;
    private RaceCalendar calendar;
    private String selectedCar = "";

    public UnregistrationScreen(Connection connection, Event event, RaceCalendar calendar) {
        this.connection = connection;
        this.event = event;
        this.calendar = calendar;
        Driver driver = event.getDriverByName(connection.getUsername());
        this.selectedCar = driver.getCar();
    }

    public Screen processClicks(byte clickId, boolean isRightClick) {
        Screen screen = this;
        if (clickId == 20) {
            Driver driver = this.event.getDriverByName(this.connection.getUsername());
            this.event.removeDriver(driver);
            log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " un-registered from " + this.event));
            screen = new TrackerScreen(this.connection, this.calendar.getTitle(), this.event);
            screen.display();
        } else if (clickId == 21) {
            screen = new EventListScreen(this.connection, this.calendar);
            screen.display();
        }
        return screen;
    }

    public void updateTexts(byte clickId, String text) {
    }

    public void display() {
        byte connectionId = this.connection.getConnId();
        this.connection.getHost().clearAllButtons(connectionId);
        int TOPSTART = 50;
        int LINESIZE = 15;
        int BUTTONID = 50;
        int TOP = TOPSTART;
        this.connection.getHost().createButton("", LINESIZE, 120, 40, TOP, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton(this.calendar.getTitle(), LINESIZE, 120, 40, TOP, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton(this.event.getIdEvent(), LINESIZE, 8, 40, TOP += LINESIZE, BUTTONID++, 33, connectionId);
        this.connection.getHost().createButton(this.event.getTitle(), LINESIZE, 112, 48, TOP, BUTTONID++, 96, connectionId);
        this.connection.getHost().createButton("Username:", LINESIZE, 30, 40, TOP += LINESIZE, BUTTONID++, 33, connectionId);
        this.connection.getHost().createButton("^7" + this.connection.getUsername(), LINESIZE, 90, 70, TOP, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("Car:", LINESIZE, 30, 40, TOP += LINESIZE, BUTTONID++, 33, connectionId);
        HashSet allowedCars = (HashSet)this.event.getAllowedCars().clone();
        int counter = 0;
        for (String car : allowedCars) {
            if (this.selectedCar.equalsIgnoreCase(car)) {
                this.connection.getHost().createButton("^7" + car, LINESIZE, 30, 70 + counter % 3 * 30, TOP + LINESIZE * (counter / 3), ++BUTTONID, 32, connectionId);
            } else {
                this.connection.getHost().createButton(car, LINESIZE, 30, 70 + counter % 3 * 30, TOP + LINESIZE * (counter / 3), ++BUTTONID, 32, connectionId);
            }
            this.carMapping.put((byte)BUTTONID, car);
            ++counter;
        }
        this.connection.getHost().createButton("", LINESIZE, 60, 40, TOP += LINESIZE * (counter / 3) + LINESIZE, 19, 32, connectionId);
        this.connection.getHost().createButton("^2Un-Register", LINESIZE, 60, 40, TOP, 20, 40, connectionId);
        this.connection.getHost().createButton("", LINESIZE, 60, 100, TOP, 22, 32, connectionId);
        this.connection.getHost().createButton("^3Cancel ", LINESIZE, 60, 100, TOP, 21, 40, connectionId);
    }
}

