/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Driver;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.Screens.AbstractScreen;
import it.starblue.LFS.LFSNextRace.Screens.CalendarListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerScreen
extends AbstractScreen
implements Screen {
    private String mainTitle;
    private Event event;
    private static int MAXDRIVERS = 32;
    private int page = 1;

    public TrackerScreen(Connection connection, String mainTitle, Event event) {
        super(connection);
        this.mainTitle = mainTitle != null ? mainTitle : "^7Starblue Tracker v1.0 Control Panel";
        this.event = event;
    }

    @Override
    public Screen processClicks(byte clickId, boolean isRightClick) {
        AbstractScreen screen = this;
        if (clickId == 1) {
            screen = new CalendarListScreen(this.connection);
            screen.display();
        } else if (clickId == 5) {
            ++this.page;
            this.display();
        } else if (clickId == 7) {
            --this.page;
            this.display();
        } else if (clickId == 3) {
            this.connection.getHost().clearAllButtons(this.getConnectionId());
            return null;
        }
        return screen;
    }

    @Override
    public void display() {
        this.connection.getHost().clearAllButtons(this.getConnectionId());
        this.createTitleButton(this.mainTitle);
        if (this.event != null) {
            this.createSubTitleButton(this.event.getTitle());
            int posCount = 1;
            Vector<Driver> drivers = this.event.getDrivers();
            this.sortDrivers(drivers);
            boolean userRegistered = false;
            for (Driver driver : drivers) {
                if (posCount > MAXDRIVERS * (this.page - 1) && posCount <= MAXDRIVERS * this.page) {
                    this.displayPB(driver, posCount, this.getConnectionId());
                }
                if (driver.getUsername().equalsIgnoreCase(this.connection.getUsername())) {
                    String output = String.valueOf(posCount) + ". " + driver.getUsername() + " " + this.getDriverPB(driver);
                    this.setOutput(output);
                    userRegistered = true;
                }
                ++posCount;
            }
            if (posCount > MAXDRIVERS * this.page) {
                this.createNextButton();
            }
            if (this.page > 1) {
                this.createPrevButton();
            }
        } else {
            this.createSubTitleButton("No event selected");
        }
        this.createOutputButton();
        this.createEventMenuAndCloseButton();
    }

    private void displayPB(Driver driver, int i, byte connectionId) {
        int pagePosition = (i - 1) % MAXDRIVERS;
        this.connection.getHost().createButton("" + i, 10, 8, 40 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 54 + pagePosition * 5, 33, connectionId);
        this.connection.getHost().createButton("", 10, 8, 40 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 55 + pagePosition * 5, 33, connectionId);
        this.connection.getHost().createButton(driver.getUsername(), 10, 30, 48 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 56 + pagePosition * 5, 96, connectionId);
        this.connection.getHost().createButton(driver.getCar(), 10, 8, 78 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 57 + pagePosition * 5, 32, connectionId);
        String driverPb = this.getDriverPB(driver);
        this.connection.getHost().createButton(driverPb, 10, 14, 86 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 58 + pagePosition * 5, 32, connectionId);
    }

    private String getDriverPB(Driver driver) {
        String driverPb = "N/A";
        if (driver.getBestLap() != 0) {
            int minutes = driver.getBestLap() / 60000;
            int seconds = (driver.getBestLap() - minutes * 60000) / 1000;
            int hundreths = (driver.getBestLap() - seconds * 1000 - minutes * 60000) / 10;
            DecimalFormat format = new DecimalFormat("00");
            driverPb = String.valueOf(minutes) + ":" + format.format(seconds) + "." + format.format(hundreths);
            if (driver.hasBetterHotlap()) {
                driverPb = "^6" + driverPb;
            }
        }
        return driverPb;
    }

    private void sortDrivers(Vector<Driver> drivers) {
        Collections.sort(drivers, new Comparator(){

            public int compare(Object o1, Object o2) {
                Driver firstDriver = (Driver)o1;
                Driver secondDriver = (Driver)o2;
                if (firstDriver.getBestLap() == 0 && secondDriver.getBestLap() != 0) {
                    return 1;
                }
                if (secondDriver.getBestLap() == 0 && firstDriver.getBestLap() != 0) {
                    return -1;
                }
                return firstDriver.getBestLap() - secondDriver.getBestLap();
            }
        });
    }

    @Override
    public void updateTexts(byte clickId, String text) {
    }
}

