/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.AbstractScreen;
import it.starblue.LFS.LFSNextRace.Screens.CalendarListScreen;
import it.starblue.LFS.LFSNextRace.Screens.RegistrationScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import it.starblue.LFS.LFSNextRace.Screens.TrackerScreen;
import it.starblue.LFS.LFSNextRace.Screens.UnregistrationScreen;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListScreen
extends AbstractScreen
implements Screen {
    protected HashMap<Byte, Event> eventsMap = new HashMap();
    protected HashMap<Byte, Event> registerMap = new HashMap();
    protected HashMap<Byte, Event> unregisterMap = new HashMap();
    protected static final int MAXEVENTS = 16;
    protected RaceCalendar calendar;
    protected int page = 1;

    public EventListScreen(Connection connection, RaceCalendar calendar) {
        super(connection);
        this.calendar = calendar;
    }

    @Override
    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (this.eventsMap.containsKey(clickId)) {
            Event event = this.eventsMap.get(clickId);
            this.connection.setSelectedEvent(event.getIdEvent());
            TrackerScreen tracker = new TrackerScreen(this.connection, this.calendar.getTitle(), event);
            tracker.display();
            return tracker;
        }
        if (clickId == 1) {
            CalendarListScreen screen = new CalendarListScreen(this.connection);
            screen.display();
            return screen;
        }
        if (clickId == 5) {
            ++this.page;
            this.display();
        } else if (clickId == 7) {
            --this.page;
            this.display();
        } else {
            if (this.registerMap.containsKey(clickId)) {
                Event event = this.registerMap.get(clickId);
                RegistrationScreen screen = new RegistrationScreen(this.connection, event, this.calendar);
                screen.display();
                return screen;
            }
            if (this.unregisterMap.containsKey(clickId)) {
                Event event = this.unregisterMap.get(clickId);
                UnregistrationScreen screen = new UnregistrationScreen(this.connection, event, this.calendar);
                screen.display();
                return screen;
            }
            if (clickId == 3) {
                this.connection.getHost().clearAllButtons(this.getConnectionId());
                return null;
            }
        }
        return this;
    }

    @Override
    public void display() {
        this.connection.getHost().clearAllButtons(this.getConnectionId());
        if (this.calendar != null) {
            this.createTitleButton(this.calendar.getTitle());
            HashMap<String, Event> events = this.calendar.getEvents();
            if (events.size() > 0) {
                this.createSubTitleButton("^2Click on one of the available Events");
                this.displayEvents(events);
            } else {
                this.createSubTitleButton("^2No events available.");
            }
        } else {
            this.createTitleButton("^7Starblue Tracker v1.0 Control Panel");
            this.createSubTitleButton("^2No calendar selected.");
        }
        this.createEventMenuAndCloseButton();
        this.createOutputButton();
    }

    protected void displayEvents(HashMap<String, Event> events) {
        int posCount = 1;
        this.resetEventMap();
        this.unregisterMap.clear();
        this.registerMap.clear();
        ArrayList<Event> eventList = new ArrayList<Event>();
        for (String eventId : events.keySet()) {
            eventList.add(events.get(eventId));
        }
        Collections.sort(eventList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Event e2 = (Event)o2;
                Event e1 = (Event)o1;
                SimpleDateFormat dateFormat = new SimpleDateFormat(LFSNextRace.getDatePattern());
                Calendar calendario = Calendar.getInstance();
                calendario.setTime(e1.getEventDate());
                calendario.setTime(e2.getEventDate());
                return e1.getEventDate().compareTo(e2.getEventDate());
            }
        });
        for (Event event : eventList) {
            if (posCount > 16 * (this.page - 1) && posCount <= 16 * this.page) {
                this.displayEvent(event, posCount, this.getConnectionId());
            }
            ++posCount;
        }
        if (posCount - 1 > 16 * this.page) {
            this.createNextButton();
        }
        if (this.page > 1) {
            this.createPrevButton();
        }
    }

    protected void displayEvent(Event event, int i, byte connectionId) {
        int buttonsPerLine = 5;
        int pagePosition = (i - 1) % 16;
        this.connection.getHost().createButton("", 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 71 + pagePosition * buttonsPerLine, 33, connectionId);
        if (this.connection.getSelectedEvent().equals(event.getIdEvent())) {
            this.connection.getHost().createButton("^6" + event.getIdEvent(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
            this.connection.getHost().createButton("^6" + LFSNextRace.stripColor(event.getTitle()), 10, 82, 48, DRIVERBUTTONTOP + pagePosition % 16 * 10, 71 + pagePosition * buttonsPerLine, 104, connectionId);
            SimpleDateFormat dateFormat = new SimpleDateFormat(LFSNextRace.getDatePattern());
            this.connection.getHost().createButton("^6" + dateFormat.format(event.getEventDate()), 10, 30, 130, DRIVERBUTTONTOP + pagePosition % 16 * 10, 72 + pagePosition * buttonsPerLine, 32, connectionId);
        } else {
            this.connection.getHost().createButton(event.getIdEvent(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
            this.connection.getHost().createButton(event.getTitle(), 10, 82, 48, DRIVERBUTTONTOP + pagePosition % 16 * 10, 71 + pagePosition * buttonsPerLine, 104, connectionId);
            SimpleDateFormat dateFormat = new SimpleDateFormat(LFSNextRace.getDatePattern());
            this.connection.getHost().createButton("^7" + dateFormat.format(event.getEventDate()), 10, 30, 130, DRIVERBUTTONTOP + pagePosition % 16 * 10, 72 + pagePosition * buttonsPerLine, 32, connectionId);
        }
        this.addEventMapping((byte)(71 + pagePosition * buttonsPerLine), event);
        if (event.isSelfRegistrationAllowed() && event.getEventDate().compareTo(new Date()) >= 0) {
            if (event.isUserRegistered(this.connection.getUsername())) {
                this.connection.getHost().createButton("^3Un-Register", 10, 20, 20, DRIVERBUTTONTOP + pagePosition % 16 * 10, 73 + pagePosition * buttonsPerLine, 40, connectionId);
                this.connection.getHost().createButton("", 10, 20, 20, DRIVERBUTTONTOP + pagePosition % 16 * 10, 74 + pagePosition * buttonsPerLine + 1, 32, connectionId);
                this.unregisterMap.put((byte)(73 + pagePosition * buttonsPerLine), event);
            } else {
                this.connection.getHost().createButton("^3Register!", 10, 20, 20, DRIVERBUTTONTOP + pagePosition % 16 * 10, 73 + pagePosition * buttonsPerLine, 40, connectionId);
                this.connection.getHost().createButton("", 10, 20, 20, DRIVERBUTTONTOP + pagePosition % 16 * 10, 74 + pagePosition * buttonsPerLine + 1, 32, connectionId);
                this.registerMap.put((byte)(73 + pagePosition * buttonsPerLine), event);
            }
        }
    }

    @Override
    public void updateTexts(byte clickId, String text) {
    }

    private void resetEventMap() {
        this.eventsMap.clear();
    }

    protected void addEventMapping(Byte clickId, Event event) {
        this.eventsMap.put(clickId, event);
    }
}

