/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Driver;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.Screens.AbstractScreen;
import it.starblue.LFS.LFSNextRace.Screens.AdminCalendarListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriversListScreen
extends AbstractScreen
implements Screen {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Screens.DriversListScreen");
    private static int MAXDRIVERS = 32;
    private static final int MINBUTTONID = 50;
    private static int TOPSTART = 3;
    private static final int FIRSTITLEHEIGHT = 12;
    private static final int SECONDTITLEHEIGHT = 12;
    private static final int NEWDRIVERBUTTON = 53;
    private static final int NEWCARBUTTON = 54;
    private static final int REGISTERBUTTON = 55;
    private HashMap<Byte, Driver> driverMap = new HashMap();
    private Event event;
    private String typedDriver = "";
    private String typedCar = "";
    private int page = 1;

    public DriversListScreen(Connection connection, Event event) {
        super(connection);
        this.event = event;
    }

    @Override
    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (clickId == 55) {
            if (this.event.getAllowedCars().contains(this.typedCar)) {
                if (this.typedDriver.length() > 0) {
                    Driver driver = new Driver(this.typedDriver, this.typedCar, 0);
                    this.event.addDriver(driver);
                    log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " added " + driver + " to " + this.event));
                    this.showOutput("Driver " + this.typedDriver + " on " + this.typedCar + " registered.");
                    this.typedDriver = "";
                    this.connection.getHost().updateButtonText(this.getConnectionId(), (byte)53, "<New Driver>");
                    this.display();
                } else {
                    this.showOutput("Can't add driver without username.");
                }
            } else {
                this.showOutput("Can't add driver: car " + this.typedCar + " is not allowed.");
            }
        } else if (this.isButtonMapped(clickId)) {
            Driver driver = this.getMappedDriver(clickId);
            this.event.removeDriver(driver);
            log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " removed " + driver + " from " + this.event));
            this.showOutput("Driver " + driver.getUsername() + " on " + driver.getCar() + " removed.");
            this.display();
        } else {
            if (clickId == 1) {
                AdminCalendarListScreen screen = new AdminCalendarListScreen(this.connection);
                screen.display();
                return screen;
            }
            if (clickId == 5) {
                ++this.page;
                this.display();
            } else if (clickId == 7) {
                --this.page;
                this.display();
            } else if (clickId == 3) {
                this.connection.getHost().clearAllButtons(this.getConnectionId());
                return null;
            }
        }
        return this;
    }

    @Override
    public void display() {
        this.connection.getHost().clearAllButtons(this.getConnectionId());
        if (this.event != null) {
            this.createTitleButton(this.event.getTitle());
            this.createRegisterDriverButtons(this.getConnectionId());
            this.displayAllEntries(this.getConnectionId());
        } else {
            this.setOutput("No event selected");
            this.createTitleButton("^7Starblue Tracker v1.0 Control Panel");
        }
        this.createEventMenuAndCloseButton();
        this.createOutputButton();
    }

    private void displayAllEntries(byte connectionId) {
        this.resetDriverMap();
        int posCount = 1;
        Vector<Driver> drivers = this.event.getDrivers();
        this.sortDriversByName(drivers);
        for (Driver driver : drivers) {
            if (posCount > MAXDRIVERS * (this.page - 1) && posCount <= MAXDRIVERS * this.page) {
                this.displayEntry(driver, posCount, connectionId);
            }
            ++posCount;
        }
        if (posCount > MAXDRIVERS * this.page) {
            this.createNextButton();
        }
        if (this.page > 1) {
            this.createPrevButton();
        }
    }

    private void sortDriversByName(Vector<Driver> drivers) {
        Collections.sort(drivers, new Comparator(){

            public int compare(Object o1, Object o2) {
                Driver firstDriver = (Driver)o1;
                Driver secondDriver = (Driver)o2;
                return firstDriver.getUsername().compareToIgnoreCase(secondDriver.getUsername());
            }
        });
    }

    private void createRegisterDriverButtons(byte connectionId) {
        String defaultDriver = "<New Driver>";
        String defaultCar = "<Car>";
        if (this.typedDriver.length() > 0) {
            defaultDriver = this.typedDriver;
        }
        if (this.typedCar.length() > 0) {
            defaultCar = this.typedCar;
        }
        this.connection.getHost().createTextButton(24, defaultDriver, 12, 60, 40, TOPSTART + 12, 53, 40, connectionId);
        this.connection.getHost().createTextButton(3, defaultCar, 12, 20, 100, TOPSTART + 12, 54, 40, connectionId);
        this.connection.getHost().createButton("^2Register", 12, 40, 120, TOPSTART + 12, 55, 40, connectionId);
    }

    private void displayEntry(Driver driver, int i, byte connectionId) {
        int pagePosition = (i - 1) % MAXDRIVERS;
        this.connection.getHost().createButton("" + i, 10, 8, 40 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 70 + pagePosition * 5, 33, connectionId);
        this.connection.getHost().createButton("", 10, 8, 40 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 71 + pagePosition * 5, 33, connectionId);
        this.connection.getHost().createButton(driver.getUsername(), 10, 30, 48 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 72 + pagePosition * 5, 96, connectionId);
        this.connection.getHost().createButton(driver.getCar(), 10, 8, 78 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 73 + pagePosition * 5, 32, connectionId);
        this.connection.getHost().createButton("^3Delete", 10, 14, 86 + pagePosition / (MAXDRIVERS / 2) * 60, DRIVERBUTTONTOP + pagePosition % (MAXDRIVERS / 2) * 10, 74 + pagePosition * 5, 40, connectionId);
        this.addDriverMapping((byte)(74 + pagePosition * 5), driver);
    }

    private void resetDriverMap() {
        this.driverMap.clear();
    }

    private void addDriverMapping(Byte clickId, Driver driver) {
        this.driverMap.put(clickId, driver);
    }

    private boolean isButtonMapped(byte clickId) {
        return this.driverMap.containsKey(clickId);
    }

    private Driver getMappedDriver(byte clickId) {
        return this.driverMap.get(clickId);
    }

    @Override
    public void updateTexts(byte clickId, String text) {
        if (clickId == 53) {
            this.typedDriver = text;
            this.connection.getHost().updateButtonText(this.getConnectionId(), clickId, this.typedDriver);
        }
        if (clickId == 54) {
            this.typedCar = text.toUpperCase();
            this.connection.getHost().updateButtonText(this.getConnectionId(), clickId, this.typedCar);
        }
    }
}

