/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.AdminEventListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import org.apache.log4j.Logger;

public class ConfirmEventDelete
implements Screen {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Screens.ConfirmEventDelete");
    private Connection connection;
    private Event event;
    private RaceCalendar calendar;
    private static final int DELETEBUTTON = 20;
    private static final int CANCELBUTTON = 21;

    public ConfirmEventDelete(Connection connection, Event event, RaceCalendar calendar) {
        this.connection = connection;
        this.event = event;
        this.calendar = calendar;
    }

    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (clickId == 20) {
            this.calendar.removeEvent(this.event);
            log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " removed Event " + this.event));
            AdminEventListScreen screen = new AdminEventListScreen(this.connection, this.calendar);
            screen.display();
            return screen;
        }
        if (clickId == 21) {
            AdminEventListScreen screen = new AdminEventListScreen(this.connection, this.calendar);
            screen.display();
            return screen;
        }
        return this;
    }

    public void updateTexts(byte clickId, String text) {
    }

    public void display() {
        byte connectionId = this.connection.getConnId();
        this.connection.getHost().clearAllButtons(connectionId);
        int TOPSTART = 50;
        int QUESTIONHEIGHT = 15;
        int EVENTHEIGHT = 10;
        int EVENTSIZEHEIGHT = 15;
        int YESNOHEIGHT = 20;
        this.connection.getHost().createButton("", QUESTIONHEIGHT, 120, 40, TOPSTART, 30, 32, connectionId);
        this.connection.getHost().createButton("Do you really want to delete the following event?", QUESTIONHEIGHT, 120, 40, TOPSTART, 31, 32, connectionId);
        this.connection.getHost().createButton(this.event.getIdEvent(), EVENTHEIGHT, 8, 40, TOPSTART + QUESTIONHEIGHT, 32, 33, connectionId);
        this.connection.getHost().createButton(this.event.getTitle(), EVENTHEIGHT, 112, 48, TOPSTART + QUESTIONHEIGHT, 33, 104, connectionId);
        this.connection.getHost().createButton("", EVENTSIZEHEIGHT, 120, 40, TOPSTART + QUESTIONHEIGHT + EVENTHEIGHT, 34, 32, connectionId);
        this.connection.getHost().createButton("This event has " + this.event.getDrivers().size() + " signed up.", EVENTSIZEHEIGHT, 120, 40, TOPSTART + QUESTIONHEIGHT + EVENTHEIGHT, 35, 32, connectionId);
        this.connection.getHost().createButton("", YESNOHEIGHT, 60, 40, TOPSTART + QUESTIONHEIGHT + EVENTHEIGHT + EVENTSIZEHEIGHT, 19, 32, connectionId);
        this.connection.getHost().createButton("^2Yes", YESNOHEIGHT, 60, 40, TOPSTART + QUESTIONHEIGHT + EVENTHEIGHT + EVENTSIZEHEIGHT, 20, 40, connectionId);
        this.connection.getHost().createButton("", YESNOHEIGHT, 60, 100, TOPSTART + QUESTIONHEIGHT + EVENTHEIGHT + EVENTSIZEHEIGHT, 22, 32, connectionId);
        this.connection.getHost().createButton("^3No ", YESNOHEIGHT, 60, 100, TOPSTART + QUESTIONHEIGHT + EVENTHEIGHT + EVENTSIZEHEIGHT, 21, 40, connectionId);
    }
}

