/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.AbstractScreen;
import it.starblue.LFS.LFSNextRace.Screens.EventListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarListScreen
extends AbstractScreen
implements Screen {
    protected HashMap<Byte, RaceCalendar> calendarsMap = new HashMap();
    protected static final int MAXCALENDARS = 16;
    protected int page = 1;

    public CalendarListScreen(Connection connection) {
        super(connection);
    }

    @Override
    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (this.calendarsMap.containsKey(clickId)) {
            RaceCalendar calendar = this.calendarsMap.get(clickId);
            this.connection.setSelectedCalendar(calendar.getIdCalendar());
            this.connection.setSelectedEvent("");
            EventListScreen eventList = new EventListScreen(this.connection, calendar);
            eventList.display();
            return eventList;
        }
        if (clickId == 1) {
            CalendarListScreen screen = new CalendarListScreen(this.connection);
            screen.display();
            return screen;
        }
        if (clickId == 5) {
            ++this.page;
            this.display();
        } else if (clickId == 7) {
            --this.page;
            this.display();
        } else if (clickId == 3) {
            this.connection.getHost().clearAllButtons(this.getConnectionId());
            return null;
        }
        return this;
    }

    @Override
    public void display() {
        this.connection.getHost().clearAllButtons(this.getConnectionId());
        this.createTitleButton("^7Starblue Tracker v1.0 Control Panel");
        HashMap<String, RaceCalendar> calendars = LFSNextRace.getCalendars();
        if (calendars.size() > 0) {
            this.createSubTitleButton("^2Click on one of the available Calendars");
            this.displayCalendars(calendars);
        } else {
            this.createSubTitleButton("^2No calendars available.");
        }
        this.createEventMenuAndCloseButton();
        this.createOutputButton();
    }

    protected void displayCalendars(HashMap<String, RaceCalendar> calendars) {
        int posCount = 1;
        this.resetCalendarsMap();
        for (String calendarId : calendars.keySet()) {
            if (posCount > 16 * (this.page - 1) && posCount <= 16 * this.page) {
                this.displayCalendar(calendars.get(calendarId), posCount, this.getConnectionId());
            }
            ++posCount;
        }
        if (posCount > 16 * this.page) {
            this.createNextButton();
        }
        if (this.page > 1) {
            this.createPrevButton();
        }
    }

    protected void displayCalendar(RaceCalendar calendar, int i, byte connectionId) {
        int pagePosition = (i - 1) % 16;
        int buttonsPerLine = 3;
        this.connection.getHost().createButton("", 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 71 + pagePosition * buttonsPerLine, 33, connectionId);
        if (LFSNextRace.getDefaultCalendar().equals(calendar.getIdCalendar())) {
            this.connection.getHost().createButton("^6" + calendar.getIdCalendar(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
        } else {
            this.connection.getHost().createButton(calendar.getIdCalendar(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
        }
        this.connection.getHost().createButton(calendar.getTitle(), 10, 112, 48, DRIVERBUTTONTOP + pagePosition % 16 * 10, 72 + pagePosition * buttonsPerLine, 104, connectionId);
        this.addCalendarMapping((byte)(72 + pagePosition * buttonsPerLine), calendar);
    }

    @Override
    public void updateTexts(byte clickId, String text) {
    }

    protected void resetCalendarsMap() {
        this.calendarsMap.clear();
    }

    protected void addCalendarMapping(Byte clickId, RaceCalendar calendar) {
        this.calendarsMap.put(clickId, calendar);
    }
}

