/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.AdminEventListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class AdminEventScreen
implements Screen {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Screens.AdminEventScreen");
    private static final int TOPBUTTON = 19;
    private static final int OKBUTTON = 20;
    private static final int CANCELBUTTON = 21;
    private static final int TITLEBUTTON = 22;
    private static final int DATEBUTTON = 23;
    private static final int HOTLAPYES = 24;
    private static final int HOTLAPNO = 25;
    private static final int SELFYES = 26;
    private static final int SELFNO = 27;
    private static final int NORMALBUTTON = 28;
    private static final int REVBUTTON = 29;
    private static final int TRACKBUTTON = 30;
    private Connection connection;
    private RaceCalendar calendar;
    private Event event;
    private TreeMap<String, String> tracks = new TreeMap();
    private HashMap<Byte, String> trackMapping;
    private String[] cars;
    private HashMap<Byte, String> carMapping;
    private boolean newEvent;

    public AdminEventScreen(Connection connection, RaceCalendar calendar, Event event) {
        this.tracks.put("00", "BL GP Track");
        this.tracks.put("01", "BL Rallycross");
        this.tracks.put("10", "SO Classic");
        this.tracks.put("11", "SO Sprint 1");
        this.tracks.put("12", "SO Sprint 2");
        this.tracks.put("13", "SO City Long");
        this.tracks.put("14", "SO Town Course");
        this.tracks.put("15", "SO Chicane Route");
        this.tracks.put("20", "FE Club");
        this.tracks.put("21", "FE Green");
        this.tracks.put("22", "FE Gold");
        this.tracks.put("23", "FE Black");
        this.tracks.put("24", "FE Rallycross");
        this.tracks.put("25", "FE RallyX Green");
        this.tracks.put("40", "KY Ring Oval");
        this.tracks.put("41", "KY Ring National");
        this.tracks.put("42", "KY Ring GP Long");
        this.tracks.put("50", "WE International");
        this.tracks.put("60", "AS Cadet");
        this.tracks.put("61", "AS Club");
        this.tracks.put("62", "AS National");
        this.tracks.put("63", "AS Historic");
        this.tracks.put("64", "AS Grand Prix");
        this.tracks.put("65", "AS Grand Touring");
        this.tracks.put("66", "AS North");
        this.trackMapping = new HashMap();
        this.cars = new String[]{"UF1", "XFG", "XRG", "LX4", "LX6", "RB4", "FXO", "XRT", "RAC", "FZ5", "UFR", "XFR", "FXR", "XRR", "FZR", "MRT", "FBM", "FOX", "FO8", "BF1"};
        this.carMapping = new HashMap();
        this.newEvent = true;
        if (event != null) {
            this.newEvent = false;
            this.event = (Event)event.clone();
        } else {
            this.event = new Event();
        }
        this.connection = connection;
        this.calendar = calendar;
    }

    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (this.carMapping.containsKey(clickId)) {
            if (this.event.getAllowedCars().contains(this.carMapping.get(clickId))) {
                this.event.getAllowedCars().remove(this.carMapping.get(clickId));
            } else {
                this.event.getAllowedCars().add(this.carMapping.get(clickId));
            }
            this.display();
        } else if (this.trackMapping.containsKey(clickId)) {
            String reverseBit = this.event.getTrack().substring(this.event.getTrack().length() - 1);
            String newTrack = String.valueOf(this.trackMapping.get(clickId)) + reverseBit;
            this.event.setTrack(newTrack);
            this.display();
        } else if (clickId == 28) {
            String trackBits = this.event.getTrack().substring(0, this.event.getTrack().length() - 1);
            String newTrack = String.valueOf(trackBits) + "0";
            this.event.setTrack(newTrack);
            this.display();
        } else if (clickId == 29) {
            String trackBits = this.event.getTrack().substring(0, this.event.getTrack().length() - 1);
            String newTrack = String.valueOf(trackBits) + "1";
            this.event.setTrack(newTrack);
            this.display();
        } else if (clickId == 26) {
            this.event.setSelfRegistrationAllowed(true);
            this.display();
        } else if (clickId == 27) {
            this.event.setSelfRegistrationAllowed(false);
            this.display();
        } else if (clickId == 24) {
            this.event.setHotlapsAllowed(true);
            this.display();
        } else if (clickId == 25) {
            this.event.setHotlapsAllowed(false);
            this.display();
        } else {
            if (clickId == 20) {
                AdminEventListScreen screen = new AdminEventListScreen(this.connection, this.calendar);
                if (this.newEvent) {
                    this.calendar.addEvent(this.event);
                    log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " added Event " + this.event));
                    screen.setOutput("Event " + this.event.getIdEvent() + " added.");
                } else {
                    this.calendar.replaceEvent(this.event);
                    log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " edited Event " + this.event));
                    screen.setOutput("Event " + this.event.getIdEvent() + " edited.");
                }
                screen.display();
                return screen;
            }
            if (clickId == 21) {
                AdminEventListScreen screen = new AdminEventListScreen(this.connection, this.calendar);
                screen.display();
                return screen;
            }
        }
        return this;
    }

    public void updateTexts(byte clickId, String text) {
        if (clickId == 22) {
            this.event.setTitle(text);
            this.connection.getHost().updateButtonText(this.connection.getConnId(), clickId, text);
        } else if (clickId == 23) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(LFSNextRace.getDatePattern());
                Date newDate = dateFormat.parse(text);
                this.event.setEventDate(newDate);
                this.connection.getHost().updateButtonText(this.connection.getConnId(), clickId, text);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void display() {
        byte connectionId = this.connection.getConnId();
        this.connection.getHost().clearAllButtons(connectionId);
        int TOPSTART = 5;
        int HEADERHEIGHT = 15;
        int BUTTONID = 50;
        this.connection.getHost().createButton("", HEADERHEIGHT, 120, 40, TOPSTART, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("^2Modify Event Details", HEADERHEIGHT, 120, 40, TOPSTART, 19, 32, connectionId);
        int CURTOP = TOPSTART + HEADERHEIGHT;
        int DATAHEIGHT = 10;
        this.connection.getHost().createButton("", DATAHEIGHT, 20, 40, CURTOP, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("^3Title:", DATAHEIGHT, 20, 40, CURTOP, BUTTONID++, 32, connectionId);
        if (this.event.getTitle().length() == 0) {
            this.connection.getHost().createTextButton(50, "<Insert title here>", DATAHEIGHT, 100, 60, CURTOP, 22, 40, connectionId);
        } else {
            this.connection.getHost().createTextButton(50, this.event.getTitle(), DATAHEIGHT, 100, 60, CURTOP, 22, 40, connectionId);
        }
        this.connection.getHost().createButton("", DATAHEIGHT, 20, 40, CURTOP += DATAHEIGHT, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("^3Date:", DATAHEIGHT, 20, 40, CURTOP, BUTTONID++, 32, connectionId);
        SimpleDateFormat dateFormat = new SimpleDateFormat(LFSNextRace.getDatePattern());
        this.connection.getHost().createTextButton(20, "^7" + dateFormat.format(this.event.getEventDate()), DATAHEIGHT, 40, 60, CURTOP, 23, 40, connectionId);
        this.connection.getHost().createButton("", DATAHEIGHT, 30, 100, CURTOP, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("^3Hotlaps:", DATAHEIGHT, 30, 100, CURTOP, BUTTONID++, 32, connectionId);
        if (this.event.isHotlapsAllowed()) {
            this.connection.getHost().createButton("^7Yes", DATAHEIGHT, 15, 130, CURTOP, 24, 40, connectionId);
            this.connection.getHost().createButton("No", DATAHEIGHT, 15, 145, CURTOP, 25, 40, connectionId);
        } else {
            this.connection.getHost().createButton("Yes", DATAHEIGHT, 15, 130, CURTOP, 24, 40, connectionId);
            this.connection.getHost().createButton("^7No", DATAHEIGHT, 15, 145, CURTOP, 25, 40, connectionId);
        }
        this.connection.getHost().createButton("", DATAHEIGHT, 30, 40, CURTOP += DATAHEIGHT, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("^3Track", DATAHEIGHT, 30, 40, CURTOP, BUTTONID++, 32, connectionId);
        this.connection.getHost().createButton("^7" + this.event.getTrack(), DATAHEIGHT, 30, 70, CURTOP, 30, 32, connectionId);
        if (this.event.getTrack().substring(this.event.getTrack().length() - 1).equals("1")) {
            this.connection.getHost().createButton("Normal", DATAHEIGHT, 30, 100, CURTOP, 28, 40, connectionId);
            this.connection.getHost().createButton("^7Reversed", DATAHEIGHT, 30, 130, CURTOP, 29, 40, connectionId);
        } else {
            this.connection.getHost().createButton("^7Normal", DATAHEIGHT, 30, 100, CURTOP, 28, 40, connectionId);
            this.connection.getHost().createButton("Reversed", DATAHEIGHT, 30, 130, CURTOP, 29, 40, connectionId);
        }
        CURTOP += DATAHEIGHT;
        int counter = 0;
        for (String track : this.tracks.keySet()) {
            if (track.equals(this.event.getTrack().substring(0, 2))) {
                this.connection.getHost().createButton("^7" + this.tracks.get(track), DATAHEIGHT, 30, 40 + counter % 4 * 30, CURTOP + DATAHEIGHT * (counter / 4), ++BUTTONID, 40, connectionId);
            } else {
                this.connection.getHost().createButton(this.tracks.get(track), DATAHEIGHT, 30, 40 + counter % 4 * 30, CURTOP + DATAHEIGHT * (counter / 4), ++BUTTONID, 40, connectionId);
            }
            this.trackMapping.put((byte)BUTTONID, track);
            ++counter;
        }
        this.connection.getHost().createButton("", DATAHEIGHT, 30, 100, CURTOP += DATAHEIGHT * 6, ++BUTTONID, 32, connectionId);
        this.connection.getHost().createButton("^3Self-registration:", DATAHEIGHT, 30, 100, CURTOP, ++BUTTONID, 32, connectionId);
        if (this.event.isSelfRegistrationAllowed()) {
            this.connection.getHost().createButton("^7Yes", DATAHEIGHT, 15, 130, CURTOP, 26, 40, connectionId);
            this.connection.getHost().createButton("No", DATAHEIGHT, 15, 145, CURTOP, 27, 40, connectionId);
        } else {
            this.connection.getHost().createButton("Yes", DATAHEIGHT, 15, 130, CURTOP, 26, 40, connectionId);
            this.connection.getHost().createButton("^7No", DATAHEIGHT, 15, 145, CURTOP, 27, 40, connectionId);
        }
        this.connection.getHost().createButton("", DATAHEIGHT, 120, 40, CURTOP += DATAHEIGHT, ++BUTTONID, 32, connectionId);
        this.connection.getHost().createButton("^3Allowed Cars", DATAHEIGHT, 120, 40, CURTOP, ++BUTTONID, 32, connectionId);
        CURTOP += DATAHEIGHT;
        counter = 0;
        String[] stringArray = this.cars;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String car = stringArray[n];
            if (this.event.getAllowedCars().contains(car)) {
                this.connection.getHost().createButton("^7" + car, DATAHEIGHT, 30, 40 + counter % 4 * 30, CURTOP + DATAHEIGHT * (counter / 4), ++BUTTONID, 40, connectionId);
            } else {
                this.connection.getHost().createButton(car, DATAHEIGHT, 30, 40 + counter % 4 * 30, CURTOP + DATAHEIGHT * (counter / 4), ++BUTTONID, 40, connectionId);
            }
            this.carMapping.put((byte)BUTTONID, car);
            ++counter;
            ++n;
        }
        int YESNOHEIGHT = 15;
        this.connection.getHost().createButton("", YESNOHEIGHT, 60, 40, CURTOP += DATAHEIGHT * 5, ++BUTTONID, 32, connectionId);
        this.connection.getHost().createButton("^2Ok", YESNOHEIGHT, 60, 40, CURTOP, 20, 40, connectionId);
        this.connection.getHost().createButton("", YESNOHEIGHT, 60, 100, CURTOP, ++BUTTONID, 32, connectionId);
        this.connection.getHost().createButton("^3Cancel ", YESNOHEIGHT, 60, 100, CURTOP, 21, 40, connectionId);
    }
}

