/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.AdminCalendarListScreen;
import it.starblue.LFS.LFSNextRace.Screens.AdminEventScreen;
import it.starblue.LFS.LFSNextRace.Screens.ConfirmEventDelete;
import it.starblue.LFS.LFSNextRace.Screens.DriversListScreen;
import it.starblue.LFS.LFSNextRace.Screens.EventListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class AdminEventListScreen
extends EventListScreen
implements Screen {
    public static final int NEWEVENT = 52;
    public static final int ADDBUTTON = 53;
    private HashMap<Byte, Event> deleteMap = new HashMap();
    private boolean editMode = false;
    private Event eventToEdit;

    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (this.eventsMap.containsKey(clickId) && !isRightClick) {
            Event event = (Event)this.eventsMap.get(clickId);
            this.connection.setSelectedEvent(event.getIdEvent());
            DriversListScreen tracker = new DriversListScreen(this.connection, event);
            tracker.display();
            return tracker;
        }
        if (this.eventsMap.containsKey(clickId) && isRightClick) {
            this.eventToEdit = (Event)this.eventsMap.get(clickId);
            this.editMode = true;
            this.display();
        } else {
            if (this.deleteMap.containsKey(clickId)) {
                Event event = this.deleteMap.get(clickId);
                ConfirmEventDelete screen = new ConfirmEventDelete(this.connection, event, this.calendar);
                screen.display();
                return screen;
            }
            if (clickId == 53 && !this.editMode) {
                AdminEventScreen screen = new AdminEventScreen(this.connection, this.calendar, null);
                screen.display();
                return screen;
            }
            if (clickId == 53 && this.editMode) {
                this.editMode = false;
                AdminEventScreen screen = new AdminEventScreen(this.connection, this.calendar, this.eventToEdit);
                screen.display();
                return screen;
            }
            if (clickId == 1) {
                AdminCalendarListScreen screen = new AdminCalendarListScreen(this.connection);
                screen.display();
                return screen;
            }
            if (clickId == 5) {
                ++this.page;
                this.display();
            } else if (clickId == 7) {
                --this.page;
                this.display();
            } else if (clickId == 3) {
                this.connection.getHost().clearAllButtons(this.getConnectionId());
                return null;
            }
        }
        return this;
    }

    public AdminEventListScreen(Connection connection, RaceCalendar calendar) {
        super(connection, calendar);
    }

    public void display() {
        this.deleteMap.clear();
        this.connection.getHost().clearAllButtons(this.getConnectionId());
        if (this.calendar != null) {
            this.createTitleButton(this.calendar.getTitle());
            if (this.editMode) {
                this.connection.getHost().createButton(this.eventToEdit.getTitle(), 12, 80, 40, TOPSTART + 12, 52, 40, this.getConnectionId());
                this.connection.getHost().createButton("^3Edit", 12, 40, 120, TOPSTART + 12, 53, 40, this.getConnectionId());
            } else {
                this.connection.getHost().createButton("^2Use Right Click to Edit", 12, 80, 40, TOPSTART + 12, 52, 40, this.getConnectionId());
                this.connection.getHost().createButton("^3Add New Event", 12, 40, 120, TOPSTART + 12, 53, 40, this.getConnectionId());
            }
            HashMap<String, Event> events = this.calendar.getEvents();
            if (events.size() > 0) {
                this.displayEvents(events);
            }
        } else {
            this.createTitleButton("^7Starblue Tracker v1.0 Control Panel");
            this.createSubTitleButton("^2No calendar selected.");
        }
        this.createEventMenuAndCloseButton();
        this.createOutputButton();
    }

    protected void displayEvent(Event event, int i, byte connectionId) {
        int buttonsPerLine = 5;
        int pagePosition = (i - 1) % 16;
        this.connection.getHost().createButton("", 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 71 + pagePosition * buttonsPerLine, 33, connectionId);
        this.connection.getHost().createButton(event.getIdEvent(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
        this.connection.getHost().createButton(event.getTitle(), 10, 72, 48, DRIVERBUTTONTOP + pagePosition % 16 * 10, 72 + pagePosition * buttonsPerLine, 104, connectionId);
        SimpleDateFormat dateFormat = new SimpleDateFormat(LFSNextRace.getDatePattern());
        this.connection.getHost().createButton("^7" + dateFormat.format(event.getEventDate()), 10, 30, 120, DRIVERBUTTONTOP + pagePosition % 16 * 10, 73 + pagePosition * buttonsPerLine, 32, connectionId);
        this.connection.getHost().createButton("^3Del", 10, 10, 150, DRIVERBUTTONTOP + pagePosition % 16 * 10, 74 + pagePosition * buttonsPerLine, 40, connectionId);
        this.deleteMap.put((byte)(74 + pagePosition * buttonsPerLine), event);
        this.addEventMapping((byte)(72 + pagePosition * buttonsPerLine), event);
    }

    public void updateTexts(byte clickId, String text) {
    }
}

