/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.AdminEventListScreen;
import it.starblue.LFS.LFSNextRace.Screens.CalendarListScreen;
import it.starblue.LFS.LFSNextRace.Screens.ConfirmCalendarDelete;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AdminCalendarListScreen
extends CalendarListScreen
implements Screen {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Screens.AdminCalendarListScreen");
    public static final int NEWCALENDAR = 52;
    public static final int ADDBUTTON = 53;
    private HashMap<Byte, RaceCalendar> defaultMap = new HashMap();
    private HashMap<Byte, RaceCalendar> deleteMap = new HashMap();
    private boolean renameMode = false;
    private RaceCalendar renamingCalendar;
    private String typedCalendar = "";

    public Screen processClicks(byte clickId, boolean isRightClick) {
        if (this.calendarsMap.containsKey(clickId) && !isRightClick) {
            RaceCalendar calendar = (RaceCalendar)this.calendarsMap.get(clickId);
            this.connection.setSelectedCalendar(calendar.getIdCalendar());
            this.connection.setSelectedEvent("");
            AdminEventListScreen eventList = new AdminEventListScreen(this.connection, calendar);
            eventList.display();
            return eventList;
        }
        if (this.calendarsMap.containsKey(clickId) && isRightClick) {
            this.renamingCalendar = (RaceCalendar)this.calendarsMap.get(clickId);
            this.typedCalendar = this.renamingCalendar.getTitle();
            this.renameMode = true;
            this.display();
        } else if (this.defaultMap.containsKey(clickId)) {
            RaceCalendar calendar = this.defaultMap.get(clickId);
            LFSNextRace.setDefaultCalendar(calendar.getIdCalendar());
            log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " set new default calendar: " + calendar));
            this.setOutput("New default calendar selected.");
            this.display();
        } else {
            if (this.deleteMap.containsKey(clickId)) {
                RaceCalendar calendar = this.deleteMap.get(clickId);
                ConfirmCalendarDelete screen = new ConfirmCalendarDelete(this.connection, calendar);
                screen.display();
                return screen;
            }
            if (clickId == 53 && !this.renameMode) {
                if (this.typedCalendar.length() > 0) {
                    RaceCalendar calendar = LFSNextRace.addCalendar(this.typedCalendar);
                    log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " added new calendar: " + calendar));
                    this.setOutput("New calendar added.");
                    this.typedCalendar = "";
                    this.display();
                } else {
                    this.showOutput("Can't add Calendar without a name.");
                }
            } else if (clickId == 53 && this.renameMode) {
                if (this.typedCalendar.length() > 0) {
                    this.renamingCalendar.setTitle(this.typedCalendar);
                    this.renameMode = false;
                    this.typedCalendar = "";
                    log.info((Object)(this.connection.getHost() + " Connection " + this.connection + " renamed calendar " + this.renamingCalendar));
                    this.setOutput("Calendar " + this.renamingCalendar.getIdCalendar() + " renamed.");
                    this.display();
                } else {
                    this.showOutput("Type a new name for calendar " + this.renamingCalendar.getIdCalendar());
                }
            } else {
                if (clickId == 1) {
                    AdminCalendarListScreen screen = new AdminCalendarListScreen(this.connection);
                    screen.display();
                    return screen;
                }
                if (clickId == 3) {
                    this.connection.getHost().clearAllButtons(this.getConnectionId());
                    return null;
                }
                if (clickId == 5) {
                    ++this.page;
                    this.display();
                } else if (clickId == 7) {
                    --this.page;
                    this.display();
                }
            }
        }
        return this;
    }

    public AdminCalendarListScreen(Connection connection) {
        super(connection);
    }

    public void display() {
        this.defaultMap.clear();
        this.deleteMap.clear();
        this.connection.getHost().clearAllButtons(this.getConnectionId());
        this.createTitleButton("^7Starblue Tracker v1.0 Control Panel");
        String calendarName = "<New Calendar>";
        if (this.typedCalendar.length() > 0) {
            calendarName = this.typedCalendar;
        }
        this.connection.getHost().createTextButton(40, calendarName, 12, 80, 40, TOPSTART + 12, 52, 40, this.getConnectionId());
        if (this.renameMode) {
            this.connection.getHost().createButton("^2Rename", 12, 40, 120, TOPSTART + 12, 53, 40, this.getConnectionId());
        } else {
            this.connection.getHost().createButton("^2Add", 12, 40, 120, TOPSTART + 12, 53, 40, this.getConnectionId());
        }
        HashMap<String, RaceCalendar> calendars = LFSNextRace.getCalendars();
        if (calendars.size() > 0) {
            this.displayCalendars(calendars);
        }
        this.createEventMenuAndCloseButton();
        this.createOutputButton();
    }

    protected void displayCalendar(RaceCalendar calendar, int i, byte connectionId) {
        int pagePosition = (i - 1) % 16;
        int buttonsPerLine = 5;
        this.connection.getHost().createButton("", 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 71 + pagePosition * buttonsPerLine, 33, connectionId);
        if (LFSNextRace.getDefaultCalendar().equals(calendar.getIdCalendar())) {
            this.connection.getHost().createButton("^6" + calendar.getIdCalendar(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
        } else {
            this.connection.getHost().createButton(calendar.getIdCalendar(), 10, 8, 40, DRIVERBUTTONTOP + pagePosition % 16 * 10, 70 + pagePosition * buttonsPerLine, 33, connectionId);
        }
        this.connection.getHost().createButton(calendar.getTitle(), 10, 72, 48, DRIVERBUTTONTOP + pagePosition % 16 * 10, 72 + pagePosition * buttonsPerLine, 104, connectionId);
        this.connection.getHost().createButton("^3Delete", 10, 20, 120, DRIVERBUTTONTOP + pagePosition % 16 * 10, 73 + pagePosition * buttonsPerLine, 40, connectionId);
        if (LFSNextRace.getDefaultCalendar().equals(calendar.getIdCalendar())) {
            this.connection.getHost().createButton("^6Default", 10, 20, 140, DRIVERBUTTONTOP + pagePosition % 16 * 10, 74 + pagePosition * buttonsPerLine, 40, connectionId);
        } else {
            this.connection.getHost().createButton("Default", 10, 20, 140, DRIVERBUTTONTOP + pagePosition % 16 * 10, 74 + pagePosition * buttonsPerLine, 40, connectionId);
        }
        this.defaultMap.put((byte)(74 + pagePosition * buttonsPerLine), calendar);
        this.deleteMap.put((byte)(73 + pagePosition * buttonsPerLine), calendar);
        this.addCalendarMapping((byte)(72 + pagePosition * buttonsPerLine), calendar);
    }

    public void updateTexts(byte clickId, String text) {
        if (clickId == 52) {
            this.typedCalendar = text;
            this.connection.getHost().updateButtonText(this.getConnectionId(), clickId, this.typedCalendar);
        }
    }
}

