/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace.Screens;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import org.apache.log4j.Logger;

public abstract class AbstractScreen
implements Screen {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Screens.AbstractScreen");
    protected static final int MINBUTTONID = 50;
    protected static int TOPSTART = 3;
    protected static final int FIRSTITLEHEIGHT = 12;
    protected static final int SECONDTITLEHEIGHT = 12;
    protected static final String programVersion = "^7Starblue Tracker v1.0 Control Panel";
    protected static final int MAXDRIVERS = 32;
    protected static final int DRIVERBUTTONHEIGHT = 10;
    protected static final int DRIVERBUTTONTOP = TOPSTART + 12 + 12;
    protected static final int STATUSBARHEIGHT = 12;
    protected static final int BASELISTID = 70;
    protected static final int STATUSBARID = 40;
    protected static final int EVENTMENU = 1;
    protected static final int CLOSEBUTTON = 3;
    protected static final int NEXTBUTTON = 5;
    protected static final int PREVBUTTON = 7;
    protected Connection connection;
    private String output = "Have a good day";

    public AbstractScreen(Connection connection) {
        log.debug((Object)(connection.getHost() + " creating new Screen " + this.getClass() + " for " + connection));
        this.connection = connection;
    }

    public abstract Screen processClicks(byte var1, boolean var2);

    public abstract void display();

    protected void createTitleButton(String title) {
        this.connection.getHost().createButton(title, 12, 100, 50, TOPSTART, 50, 32, this.getConnectionId());
        this.connection.getHost().createButton("", 12, 100, 50, TOPSTART, 51, 32, this.getConnectionId());
    }

    protected void createSubTitleButton(String subtitle) {
        this.connection.getHost().createButton(subtitle, 12, 120, 40, TOPSTART + 12, 52, 32, this.getConnectionId());
        this.connection.getHost().createButton("", 12, 120, 40, TOPSTART + 12, 53, 32, this.getConnectionId());
    }

    protected void createOutputButton() {
        this.connection.getHost().createButton("^2" + this.output, 12, 80, 80, DRIVERBUTTONTOP + 160, 40, 32, this.getConnectionId());
        this.connection.getHost().createButton("", 12, 80, 80, DRIVERBUTTONTOP + 160, 41, 32, this.getConnectionId());
    }

    protected void createEventMenuAndCloseButton() {
        this.connection.getHost().createButton("^1Close", 12, 20, 40, DRIVERBUTTONTOP + 160, 3, 40, this.getConnectionId());
        this.connection.getHost().createButton("", 12, 20, 40, DRIVERBUTTONTOP + 160, 4, 32, this.getConnectionId());
        this.connection.getHost().createButton("^3Events", 12, 20, 60, DRIVERBUTTONTOP + 160, 1, 40, this.getConnectionId());
        this.connection.getHost().createButton("", 12, 20, 60, DRIVERBUTTONTOP + 160, 2, 32, this.getConnectionId());
    }

    protected void createNextButton() {
        this.connection.getHost().createButton("^3Next", 10, 15, 160, 177, 5, 40, this.getConnectionId());
        this.connection.getHost().createButton("", 10, 15, 160, 177, 6, 32, this.getConnectionId());
    }

    protected void createPrevButton() {
        this.connection.getHost().createButton("^3Prev", 10, 15, 160, 167, 7, 40, this.getConnectionId());
        this.connection.getHost().createButton("", 10, 15, 160, 167, 8, 32, this.getConnectionId());
    }

    protected void testButtons() {
        int x = 0;
        while (x < 150) {
            this.connection.getHost().createButton("" + x, 5, 5, x / 40 * 5, x % 40 * 5, x, x, this.getConnectionId());
            ++x;
        }
    }

    protected void showOutput(String string) {
        this.output = string;
        this.connection.getHost().updateButtonText(this.getConnectionId(), (byte)40, "^2" + string);
    }

    public byte getConnectionId() {
        return this.connection.getConnId();
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

