/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import it.starblue.LFS.LFSNextRace.Event;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceCalendar {
    private String idCalendar = "";
    private String title = "";
    private HashMap<String, Event> events = new HashMap();

    public RaceCalendar(String calendar, String title) {
        this.idCalendar = calendar;
        this.title = title;
    }

    public HashMap<String, Event> getEvents() {
        return (HashMap)this.events.clone();
    }

    public void setEvents(HashMap<String, Event> events) {
        this.events = events;
    }

    public String getIdCalendar() {
        return this.idCalendar;
    }

    public void setIdCalendar(String idCalendar) {
        this.idCalendar = idCalendar;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Event getNextEvent() {
        HashMap eventList = (HashMap)this.events.clone();
        Event nextEvent = null;
        for (String key : eventList.keySet()) {
            Event event;
            if (nextEvent != null && nextEvent.getEventDate().compareTo(((Event)eventList.get(key)).getEventDate()) <= 0 || new Date().compareTo((event = (Event)eventList.get(key)).getEventDate()) >= 0) continue;
            nextEvent = event;
        }
        return nextEvent;
    }

    public synchronized void addEvent(Event event) {
        int id = 0;
        while (id++ < Integer.MAX_VALUE) {
            if (this.events.containsKey("" + id)) continue;
            event.setIdEvent("" + id);
            this.events.put(event.getIdEvent(), event);
            break;
        }
        this.events.put(event.getIdEvent(), event);
    }

    public synchronized void removeEvent(Event event) {
        this.events.remove(event.getIdEvent());
    }

    public synchronized void replaceEvent(Event event) {
        this.events.put(event.getIdEvent(), event);
    }

    public String toString() {
        return "(" + this.idCalendar + " " + this.title + ")";
    }
}

