/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFSWorld {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.LFSWorld");
    private static final long MINDELAY = 5100L;
    private long lastQuery = 0L;
    private HttpClient apache = new HttpClient();
    private String idKey;

    public LFSWorld(String idKey) {
        this.idKey = idKey;
    }

    public synchronized HashMap<String, Integer> retrieveHotlapChart(String track, String racingCar) {
        HashMap<String, Integer> hotlaps = new HashMap<String, Integer>();
        try {
            String[] pbs;
            while (this.lastQuery + 5100L > System.currentTimeMillis()) {
                Thread.sleep(100L);
            }
            log.debug((Object)("Downloading Hotlaps for track " + track + " car " + racingCar));
            GetMethod pubStat = new GetMethod("http://www.lfsworld.net/pubstat/get_stat2.php?version=1.3&idk=" + this.idKey + "&action=ch&track=" + track + "&car=" + racingCar);
            this.apache.executeMethod((HttpMethod)pubStat);
            String queryResult = pubStat.getResponseBodyAsString();
            this.lastQuery = System.currentTimeMillis();
            String[] stringArray = pbs = queryResult.split("\n");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String pb = stringArray[n];
                if (!pb.equalsIgnoreCase("ch: invalid track") && !pb.equalsIgnoreCase("ch: invalid car")) {
                    String[] data = pb.split(" ");
                    int split1 = Integer.parseInt(data[0].trim());
                    int split2 = Integer.parseInt(data[1].trim());
                    int split3 = Integer.parseInt(data[2].trim());
                    int time = Integer.parseInt(data[3].trim());
                    int flags = Integer.parseInt(data[4].trim());
                    String racer = "";
                    int x = 5;
                    while (x < data.length) {
                        racer = String.valueOf(racer) + data[x].toUpperCase() + " ";
                        ++x;
                    }
                    String id = String.valueOf(track) + racingCar + racer.trim();
                    hotlaps.put(id, time);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)"Something failed while retrieving hotlaps!", (Throwable)e);
        }
        return hotlaps;
    }

    public synchronized int retrievePB(String racerName, String track, String racingCar) throws HttpException, IOException, InterruptedException {
        int pbValue = 0;
        try {
            String[] pbs;
            while (this.lastQuery + 5100L > System.currentTimeMillis()) {
                Thread.sleep(100L);
            }
            String name = URLEncoder.encode(racerName);
            log.debug((Object)("Downloading PBs for:" + name));
            GetMethod pubStat = new GetMethod("http://www.lfsworld.net/pubstat/get_stat2.php?version=1.3&idk=" + this.idKey + "&action=pb&racer=" + name);
            this.apache.executeMethod((HttpMethod)pubStat);
            String queryResult = pubStat.getResponseBodyAsString();
            this.lastQuery = System.currentTimeMillis();
            String[] stringArray = pbs = queryResult.split("\n");
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String pb = stringArray[n];
                if (!pb.equalsIgnoreCase("pb: racer has no pbs") && !pb.equalsIgnoreCase("pb: no valid username")) {
                    String[] data = pb.split(" ");
                    String trackPb = data[0];
                    String car = data[1];
                    int time = Integer.parseInt(data[2].trim());
                    int laps = Integer.parseInt(data[3].trim());
                    if (trackPb.equals(track) && car.equals(racingCar)) {
                        pbValue = time;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Object)"Something failed while retrieving PB!", (Throwable)e);
        }
        return pbValue;
    }
}

