/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Host;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.ButtonClickedResponse;
import net.sf.jinsim.response.ButtonTypeResponse;
import net.sf.jinsim.response.ConnectionLeaveResponse;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;
import net.sf.jinsim.response.NewConnectionResponse;
import org.apache.log4j.Logger;

public class LFSNextRaceListener
implements InSimListener {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.LFSNextRaceListener");
    private Host host;

    public LFSNextRaceListener(Host host) {
        this.host = host;
    }

    public void packetReceived(InSimResponse packetData) {
        try {
            MessageResponse response;
            if (packetData.getPacketType().equals((Object)PacketType.MESSAGE_OUT)) {
                response = (MessageResponse)packetData;
                String message = response.getMessage();
                if (message.equals("$next")) {
                    log.debug((Object)(this.host + " $next has been invoked by ConnId: " + response.getConnectionId()));
                    LFSNextRace.displayInfo(this.host.getConnection(response.getConnectionId()));
                } else if (message.equals("$trackerAdmin")) {
                    log.debug((Object)(this.host + " $trackerAdmin has been invoked by ConnId: " + response.getConnectionId()));
                    LFSNextRace.displayAdminPanel(this.host.getConnection(response.getConnectionId()));
                }
                log.debug((Object)(this.host + " received this msg (" + message + ") by ConnId: " + response.getConnectionId()));
            }
            if (packetData.getPacketType().equals((Object)PacketType.NEW_CONNECTION)) {
                response = (NewConnectionResponse)packetData;
                this.host.addConnection(new Connection(this.host, response.getId(), response.isAdmin(), response.getUsername()));
            }
            if (packetData.getPacketType().equals((Object)PacketType.CONNECTION_LEFT)) {
                response = (ConnectionLeaveResponse)packetData;
                this.host.removeConnection(response.getId());
            }
            if (packetData.getPacketType().equals((Object)PacketType.BUTTON_CLICKED)) {
                response = (ButtonClickedResponse)packetData;
                LFSNextRace.clickButton(this.host.getConnection(response.getConnectionId()), response.getClickId(), response.isRightClick());
            }
            if (packetData.getPacketType().equals((Object)PacketType.BUTTON_TYPED)) {
                response = (ButtonTypeResponse)packetData;
                LFSNextRace.updateTexts(this.host.getConnection(response.getConnectionId()), response.getClickId(), response.getText());
            }
        }
        catch (Exception e) {
            log.error((Object)"Something went wrong while processing a packet inside Online Tracker.", (Throwable)e);
        }
    }
}

