/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.Driver;
import it.starblue.LFS.LFSNextRace.Event;
import it.starblue.LFS.LFSNextRace.Host;
import it.starblue.LFS.LFSNextRace.LFSWorld;
import it.starblue.LFS.LFSNextRace.RaceCalendar;
import it.starblue.LFS.LFSNextRace.Screens.DriversListScreen;
import it.starblue.LFS.LFSNextRace.Screens.Screen;
import it.starblue.LFS.LFSNextRace.Screens.TrackerScreen;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFSNextRace {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.LFSNextRace");
    private static String defaultCalendar = "1";
    private static Properties p = new Properties();
    private static LFSWorld lfsworld;
    private static HashMap<String, RaceCalendar> calendars;
    private static Vector<Host> hosts;
    private static int displayTime;
    private static String datePattern;
    private static int timezone;

    static {
        calendars = new HashMap();
        hosts = new Vector();
        displayTime = 60000;
        datePattern = "";
        timezone = 0;
    }

    private static void loadHosts() throws IOException {
        FileReader input = new FileReader("hosts.txt");
        BufferedReader bufRead = new BufferedReader(input);
        String line = bufRead.readLine();
        while (line != null && !line.trim().equals("")) {
            String[] data = line.split(";");
            if (data.length > 0) {
                try {
                    String hostname = data[0];
                    int port = Integer.parseInt(data[1]);
                    String password = data[2];
                    hosts.add(new Host(hostname, port, password));
                }
                catch (NumberFormatException e) {
                    log.fatal((Object)("Failed to parse port number from the following host line:\n" + line));
                    bufRead.close();
                    System.exit(-1);
                }
            }
            line = bufRead.readLine();
        }
        bufRead.close();
    }

    private static void loadCalendars() throws IOException {
        FileReader input = new FileReader("calendars.txt");
        BufferedReader bufRead = new BufferedReader(input);
        String line = bufRead.readLine();
        while (line != null && !line.trim().equals("")) {
            String[] data = line.split(";");
            if (data.length > 0) {
                String calendarId = data[0];
                String title = data[1];
                RaceCalendar calendar = new RaceCalendar(calendarId, title);
                calendars.put(calendarId, calendar);
            }
            line = bufRead.readLine();
        }
        bufRead.close();
    }

    private static void loadEvents() throws IOException {
        FileReader input = new FileReader("events.txt");
        BufferedReader bufRead = new BufferedReader(input);
        String line = bufRead.readLine();
        while (line != null && !line.trim().equals("")) {
            String[] data = line.split(";");
            if (data.length > 0) {
                String calendarId = data[0];
                String eventId = data[1];
                String track = data[2];
                String date = data[3];
                String title = data[4];
                boolean hotlapsAllowed = false;
                if (data[5].equalsIgnoreCase("true")) {
                    hotlapsAllowed = true;
                }
                boolean selfRegistrationAllowed = false;
                if (data[6].equalsIgnoreCase("true")) {
                    selfRegistrationAllowed = true;
                }
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    Date eventDate = formatter.parse(date);
                    Event event = new Event(eventId, title, track, eventDate, hotlapsAllowed, selfRegistrationAllowed);
                    int x = 7;
                    while (x < data.length) {
                        event.getAllowedCars().add(data[x].toUpperCase());
                        ++x;
                    }
                    calendars.get(calendarId).replaceEvent(event);
                }
                catch (ParseException e) {
                    log.fatal((Object)("Couldn't parse date of event " + eventId + " of calendar " + calendarId));
                    System.exit(-1);
                }
            }
            line = bufRead.readLine();
        }
        bufRead.close();
    }

    private static void loadDrivers() throws IOException {
        FileReader input = new FileReader("drivers.txt");
        BufferedReader bufRead = new BufferedReader(input);
        String line = bufRead.readLine();
        while (line != null && !line.trim().equals("")) {
            String[] data = line.split(";");
            if (data.length > 0) {
                String calendarId = data[0];
                String eventId = data[1];
                String username = data[2];
                String car = data[3];
                Event event = calendars.get(calendarId).getEvents().get(eventId);
                if (event.getAllowedCars().contains(car)) {
                    event.addDriver(new Driver(username, car, 0));
                } else {
                    log.fatal((Object)("Event:" + eventId + "Username:" + username + " driving not allowed car:" + car));
                    System.exit(-1);
                }
            }
            line = bufRead.readLine();
        }
        bufRead.close();
    }

    private static void run() throws InterruptedException, HttpException, IOException {
        p.load(new FileInputStream("config.ini"));
        defaultCalendar = p.getProperty("defaultCalendar");
        lfsworld = new LFSWorld(p.getProperty("idKey"));
        timezone = Integer.parseInt(p.getProperty("timezone"));
        datePattern = p.getProperty("dateFormat");
        displayTime = Integer.parseInt(p.getProperty("displayTime"));
        LFSNextRace.loadCalendars();
        LFSNextRace.loadEvents();
        LFSNextRace.loadDrivers();
        LFSNextRace.loadHosts();
        Thread keepHostConnections = new Thread(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(60000L);
                        LFSNextRace.testConnections();
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Error in the 'KeepHostConnections' thread!", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        };
        keepHostConnections.start();
        log.debug((Object)(new Date() + " Starting to retrieve PBs now!"));
        while (true) {
            LFSNextRace.saveAllData();
            LFSNextRace.updateDrivers();
            log.debug((Object)(new Date() + " Sleeping for the next 5 minutes..."));
            Thread.sleep(300000L);
        }
    }

    private static void testConnections() {
        log.debug((Object)"Check connections sequence starting...");
        for (Host host : hosts) {
            log.debug((Object)("Checking: " + host));
            host.testConnection();
        }
    }

    private static void updateDrivers() throws HttpException, IOException, InterruptedException {
        HashMap myCalendars = (HashMap)calendars.clone();
        for (String calendarId : myCalendars.keySet()) {
            HashMap<String, Event> myEvents = calendars.get(calendarId).getEvents();
            for (String eventId : myEvents.keySet()) {
                Event event = myEvents.get(eventId);
                Vector<Driver> drivers = event.getDrivers();
                LFSNextRace.retrieveAllBestLaps(drivers, event.getTrack(), event.getAllowedCars(), event.isHotlapsAllowed());
            }
        }
    }

    private static void saveAllData() {
        if (LFSNextRace.backupFile("calendars.txt") && LFSNextRace.backupFile("events.txt") && LFSNextRace.backupFile("drivers.txt")) {
            try {
                BufferedWriter calendarsFile = new BufferedWriter(new FileWriter("calendars.txt"));
                BufferedWriter eventsFile = new BufferedWriter(new FileWriter("events.txt"));
                BufferedWriter driversFile = new BufferedWriter(new FileWriter("drivers.txt"));
                HashMap myCalendars = (HashMap)calendars.clone();
                for (String calendarId : myCalendars.keySet()) {
                    RaceCalendar calendar = calendars.get(calendarId);
                    calendarsFile.write(String.valueOf(calendar.getIdCalendar()) + ";" + calendar.getTitle() + "\n");
                    HashMap<String, Event> myEvents = calendar.getEvents();
                    for (String eventId : myEvents.keySet()) {
                        Event event = myEvents.get(eventId);
                        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                        String eventDate = format.format(event.getEventDate());
                        String eventString = calendar.getIdCalendar();
                        eventString = String.valueOf(eventString) + ";" + event.getIdEvent();
                        eventString = String.valueOf(eventString) + ";" + event.getTrack();
                        eventString = String.valueOf(eventString) + ";" + eventDate;
                        eventString = String.valueOf(eventString) + ";" + event.getTitle();
                        eventString = String.valueOf(eventString) + ";" + event.isHotlapsAllowed();
                        eventString = String.valueOf(eventString) + ";" + event.isSelfRegistrationAllowed();
                        for (String car : event.getAllowedCars()) {
                            eventString = String.valueOf(eventString) + ";" + car;
                        }
                        eventsFile.write(String.valueOf(eventString) + "\n");
                        Vector<Driver> drivers = event.getDrivers();
                        for (Driver driver : drivers) {
                            driversFile.write(String.valueOf(calendar.getIdCalendar()) + ";" + event.getIdEvent() + ";" + driver.getUsername() + ";" + driver.getCar() + "\n");
                        }
                    }
                }
                calendarsFile.close();
                eventsFile.close();
                driversFile.close();
            }
            catch (IOException iOException) {}
        } else {
            log.fatal((Object)"Backup failed!!!");
            System.exit(-1);
        }
    }

    private static boolean backupFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            String backupFile = "backup" + string;
            File oldBackup = new File(backupFile);
            if (oldBackup.exists() && !oldBackup.delete()) {
                return false;
            }
            return file.renameTo(new File(backupFile));
        }
        return true;
    }

    private static void retrieveAllBestLaps(Vector<Driver> drivers, String track, HashSet<String> allowedCars, boolean hotlapsAllowed) throws HttpException, IOException, InterruptedException {
        HashMap<String, Integer> hotlaps = new HashMap<String, Integer>();
        if (hotlapsAllowed) {
            for (String car : allowedCars) {
                HashMap<String, Integer> hotlapsChart = lfsworld.retrieveHotlapChart(track, car);
                for (String key : hotlapsChart.keySet()) {
                    hotlaps.put(key, hotlapsChart.get(key));
                }
            }
        }
        for (Driver driver : drivers) {
            int pb = lfsworld.retrievePB(driver.getUsername(), track, driver.getCar());
            driver.setPb(pb);
            if (!hotlaps.containsKey(String.valueOf(track) + driver.getCar().toUpperCase() + driver.getUsername().toUpperCase())) continue;
            driver.setHotlapPb((Integer)hotlaps.get(String.valueOf(track) + driver.getCar().toUpperCase() + driver.getUsername().toUpperCase()));
        }
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, InterruptedException {
        LFSNextRace.run();
    }

    public static synchronized void displayInfo(Connection connection) {
        if (connection != null) {
            TrackerScreen screen;
            RaceCalendar selectedCalendar = calendars.get(connection.getSelectedCalendar());
            if (selectedCalendar == null || selectedCalendar.getEvents().get(connection.getSelectedEvent()) == null) {
                screen = new TrackerScreen(connection, null, null);
            } else {
                Event selectedEvent = calendars.get(connection.getSelectedCalendar()).getEvents().get(connection.getSelectedEvent());
                screen = new TrackerScreen(connection, selectedCalendar.getTitle(), selectedEvent);
            }
            screen.display();
            connection.setCurrentScreen(screen);
            log.debug((Object)(connection.getHost() + " Displayed Tracker to " + connection));
        }
    }

    public static synchronized void displayAdminPanel(Connection connection) {
        if (connection != null && connection.isAdmin()) {
            DriversListScreen screen;
            RaceCalendar selectedCalendar = calendars.get(connection.getSelectedCalendar());
            if (selectedCalendar == null || selectedCalendar.getEvents().get(connection.getSelectedEvent()) == null) {
                screen = new DriversListScreen(connection, null);
            } else {
                Event selectedEvent = calendars.get(connection.getSelectedCalendar()).getEvents().get(connection.getSelectedEvent());
                screen = new DriversListScreen(connection, selectedEvent);
            }
            screen.display();
            connection.setCurrentScreen(screen);
            log.debug((Object)(connection.getHost() + " Displayed AdminPanel to " + connection));
        }
    }

    public static synchronized void updateTexts(Connection connection, byte clickId, String text) {
        Screen screen;
        if (connection != null && (screen = connection.getCurrentScreen()) != null) {
            screen.updateTexts(clickId, text);
            connection.setActive();
        }
    }

    public static synchronized void clickButton(Connection connection, byte clickId, boolean isRightClick) {
        Screen screen;
        if (connection != null && (screen = connection.getCurrentScreen()) != null) {
            connection.setCurrentScreen(screen.processClicks(clickId, isRightClick));
        }
    }

    public static HashMap<String, RaceCalendar> getCalendars() {
        return (HashMap)calendars.clone();
    }

    public static String stripColor(String lfsString) {
        int cutpoint = lfsString.indexOf("^");
        while (cutpoint != -1) {
            String newRacerName = "";
            newRacerName = lfsString.substring(0, cutpoint);
            if (cutpoint + 2 < lfsString.length()) {
                newRacerName = String.valueOf(newRacerName) + lfsString.substring(cutpoint + 2);
            }
            lfsString = newRacerName;
            cutpoint = lfsString.indexOf("^");
        }
        return lfsString;
    }

    public static synchronized void setDefaultCalendar(String calendarId) {
        defaultCalendar = calendarId;
    }

    public static synchronized String getDefaultCalendar() {
        return defaultCalendar;
    }

    public static synchronized String getDefaultEvent() {
        if (calendars.get(defaultCalendar) != null && calendars.get(defaultCalendar).getNextEvent() != null) {
            return calendars.get(defaultCalendar).getNextEvent().getIdEvent();
        }
        return "";
    }

    public static synchronized RaceCalendar addCalendar(String calendarTitle) {
        int id = 0;
        while (id++ < Integer.MAX_VALUE) {
            if (calendars.containsKey("" + id)) continue;
            RaceCalendar calendar = new RaceCalendar("" + id, calendarTitle);
            calendars.put(calendar.getIdCalendar(), calendar);
            return calendar;
        }
        return null;
    }

    public static void removeCalendar(RaceCalendar calendar) {
        calendars.remove(calendar.getIdCalendar());
    }

    public static String getDatePattern() {
        return datePattern;
    }

    public static int getDisplayTime() {
        return displayTime;
    }
}

