/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import it.starblue.LFS.LFSNextRace.Connection;
import it.starblue.LFS.LFSNextRace.LFSNextRace;
import it.starblue.LFS.LFSNextRace.LFSNextRaceListener;
import java.io.IOException;
import java.util.HashMap;
import net.sf.jinsim.Channel;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.Tiny;
import net.sf.jinsim.request.ButtonFunctionRequest;
import net.sf.jinsim.request.ButtonRequest;
import net.sf.jinsim.request.ButtonSubtype;
import net.sf.jinsim.request.InSimRequest;
import net.sf.jinsim.request.TinyRequest;
import net.sf.jinsim.response.InSimListener;
import org.apache.log4j.Logger;

public class Host {
    static Logger log = Logger.getLogger((String)"it.starblue.LFS.LFSNextRace.Host");
    private String hostname = "";
    private int port = 0;
    private String password = "";
    private HashMap<Byte, Connection> connections = new HashMap();
    private SimpleClient jinsimClient = new SimpleClient();
    private boolean initalized = false;
    private int req = 1;

    public Host(String hostname, int port, String password) {
        this.hostname = hostname;
        this.password = password;
        this.port = port;
        this.initializeInsimConnection();
    }

    private void initializeInsimConnection() {
        try {
            this.jinsimClient = new SimpleClient();
            TCPChannel channel = new TCPChannel(this.hostname, this.port);
            this.jinsimClient.addListener((InSimListener)new LFSNextRaceListener(this));
            this.jinsimClient.connect((Channel)channel, this.password, "LFSNextRace");
            log.info((Object)(this + " connection initialized."));
            this.requestAllConnections();
            this.initalized = true;
        }
        catch (IOException e) {
            log.error((Object)(this + " Can't connect to LFS server!"), (Throwable)e);
            this.initalized = false;
        }
    }

    private void requestAllConnections() {
        TinyRequest request = new TinyRequest(Tiny.ALL_CONNECTIONS);
        try {
            this.jinsimClient.send((InSimRequest)request);
        }
        catch (IOException e) {
            log.error((Object)(this + " Failed to request all connections!"), (Throwable)e);
        }
    }

    public void testConnection() {
        if (this.initalized) {
            try {
                log.debug((Object)(this + " Checking connection..."));
                this.jinsimClient.send((InSimRequest)new TinyRequest(Tiny.NONE));
            }
            catch (IOException e) {
                log.error((Object)(this + " Test connection failed, re-inizializing Insim now"), (Throwable)e);
                this.initalized = false;
                this.initializeInsimConnection();
            }
        } else {
            this.initializeInsimConnection();
        }
    }

    public String toString() {
        return "[" + this.hostname + ":" + this.port + "]";
    }

    private void deleteButton(byte id, byte connId) {
        ButtonFunctionRequest requestDelete = new ButtonFunctionRequest();
        requestDelete.setClickId(id);
        requestDelete.setSubtype(ButtonSubtype.DELETE_BUTTON);
        requestDelete.setConnectionId(connId);
        try {
            this.jinsimClient.send((InSimRequest)requestDelete);
        }
        catch (IOException e) {
            log.error((Object)(this + " Failed to delete a button!"), (Throwable)e);
        }
    }

    public void clearAllButtons(byte connId) {
        ButtonFunctionRequest requestDelete = new ButtonFunctionRequest();
        requestDelete.setSubtype(ButtonSubtype.CLEAR);
        requestDelete.setConnectionId(connId);
        try {
            this.jinsimClient.send((InSimRequest)requestDelete);
        }
        catch (IOException e) {
            log.error((Object)(this + " Failed to clear all buttons!"), (Throwable)e);
        }
    }

    public void createTextButton(int maxChars, String string, int height, int width, int left, int top, int id, int style, byte conId) {
        ButtonRequest request = new ButtonRequest();
        request.setRequestInfo((byte)(this.req % 256 + 1));
        request.setConnectionId(conId);
        request.setText(string);
        request.setHeight((byte)height);
        request.setWidth((byte)width);
        request.setLeft((byte)left);
        request.setTop((byte)top);
        request.setClickId((byte)id);
        request.setTypeIn((byte)maxChars);
        request.setButtonStyle(style);
        try {
            this.jinsimClient.send((InSimRequest)request);
        }
        catch (IOException e) {
            log.error((Object)(this + " Failed to create Text button!"), (Throwable)e);
        }
    }

    public void createButton(String string, int height, int width, int left, int top, int id, int style, byte conId) {
        this.createTextButton(0, string, height, width, left, top, id, style, conId);
    }

    public void addConnection(Connection connection) {
        connection.setSelectedCalendar(LFSNextRace.getDefaultCalendar());
        connection.setDisplayTimeout(LFSNextRace.getDisplayTime());
        connection.setSelectedEvent(LFSNextRace.getDefaultEvent());
        this.connections.put(connection.getConnId(), connection);
    }

    public void removeConnection(byte id) {
        this.connections.remove(id);
    }

    public Connection getConnection(byte connectionId) {
        return this.connections.get(connectionId);
    }

    public void updateButtonText(byte connectionId, byte clickId, String text) {
        ButtonRequest request = new ButtonRequest();
        request.setRequestInfo((byte)(this.req % 256 + 1));
        request.setConnectionId(connectionId);
        request.setText(text);
        request.setClickId(clickId);
        try {
            this.jinsimClient.send((InSimRequest)request);
        }
        catch (IOException e) {
            log.error((Object)(this + " Failed to update Text button!"), (Throwable)e);
        }
    }
}

