/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import it.starblue.LFS.LFSNextRace.Driver;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
implements Cloneable {
    private String idEvent = "";
    private String title = "";
    private String track = "000";
    private Date eventDate = new Date();
    private HashSet<String> allowedCars = new HashSet();
    private Vector<Driver> drivers = new Vector();
    private boolean hotlapsAllowed = true;
    private boolean selfRegistrationAllowed = false;

    public Event() {
    }

    public Event(String idEvent, String title, String track, Date eventDate, boolean hotlapsAllowed, boolean selfRegistrationAllowed) {
        this.title = title;
        this.track = track;
        this.idEvent = idEvent;
        this.eventDate = eventDate;
        this.hotlapsAllowed = hotlapsAllowed;
        this.selfRegistrationAllowed = selfRegistrationAllowed;
    }

    public Object clone() {
        Event clone = null;
        try {
            clone = (Event)super.clone();
            clone.setAllowedCars((HashSet)this.allowedCars.clone());
            clone.setDrivers((Vector)this.drivers.clone());
            clone.setEventDate((Date)this.eventDate.clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public HashSet<String> getAllowedCars() {
        return this.allowedCars;
    }

    public void setAllowedCars(HashSet<String> allowedCars) {
        this.allowedCars = allowedCars;
    }

    public Vector<Driver> getDrivers() {
        return (Vector)this.drivers.clone();
    }

    public void setDrivers(Vector<Driver> drivers) {
        this.drivers = drivers;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTrack() {
        return this.track;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public String getIdEvent() {
        return this.idEvent;
    }

    public void setIdEvent(String idEvent) {
        this.idEvent = idEvent;
    }

    public synchronized void addDriver(Driver driver) {
        this.drivers.add(driver);
    }

    public synchronized void removeDriver(Driver driver) {
        this.drivers.remove(driver);
    }

    public boolean isHotlapsAllowed() {
        return this.hotlapsAllowed;
    }

    public void setHotlapsAllowed(boolean hotlapsAllowed) {
        this.hotlapsAllowed = hotlapsAllowed;
    }

    public boolean isSelfRegistrationAllowed() {
        return this.selfRegistrationAllowed;
    }

    public void setSelfRegistrationAllowed(boolean selfRegistrationAllowed) {
        this.selfRegistrationAllowed = selfRegistrationAllowed;
    }

    public synchronized boolean isUserRegistered(String username) {
        for (Driver driver : this.drivers) {
            if (!driver.getUsername().equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    public synchronized Driver getDriverByName(String username) {
        for (Driver driver : this.drivers) {
            if (!driver.getUsername().equalsIgnoreCase(username)) continue;
            return driver;
        }
        return null;
    }

    public String toString() {
        return "(" + this.idEvent + " " + this.track + " " + this.title + ")";
    }
}

