/*
 * Decompiled with CFR 0.152.
 */
package it.starblue.LFS.LFSNextRace;

import it.starblue.LFS.LFSNextRace.Host;
import it.starblue.LFS.LFSNextRace.Screens.Screen;

public class Connection {
    private byte connId;
    private String username = "";
    private boolean isAdmin;
    private Screen currentScreen;
    private String selectedCalendar = "";
    private String selectedEvent = "";
    private Thread cleaner;
    private long lastAction = 0L;
    private int displayTimeout;
    private Host host;

    public Host getHost() {
        return this.host;
    }

    public String getSelectedEvent() {
        return this.selectedEvent;
    }

    public void setSelectedEvent(String selectedEvent) {
        this.selectedEvent = selectedEvent;
    }

    public String getSelectedCalendar() {
        return this.selectedCalendar;
    }

    public void setSelectedCalendar(String selectedCalendar) {
        this.selectedCalendar = selectedCalendar;
    }

    public Connection(Host host, byte id, boolean admin, String username) {
        this.host = host;
        this.connId = id;
        this.isAdmin = admin;
        this.username = username;
        this.initCleaner();
    }

    private void initCleaner() {
        this.cleaner = new Thread(){

            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    while (now < Connection.this.lastAction + (long)Connection.this.displayTimeout) {
                        Thread.sleep(Connection.this.lastAction + (long)Connection.this.displayTimeout - now);
                        now = System.currentTimeMillis();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Connection.this.host.clearAllButtons(Connection.this.connId);
            }
        };
        this.cleaner.start();
    }

    public byte getConnId() {
        return this.connId;
    }

    public void setConnId(byte connId) {
        this.connId = connId;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Screen getCurrentScreen() {
        return this.currentScreen;
    }

    public void setCurrentScreen(Screen currentScreen) {
        this.setActive();
        this.currentScreen = currentScreen;
        if (this.cleaner == null || !this.cleaner.isAlive()) {
            this.initCleaner();
        }
    }

    public void setActive() {
        this.lastAction = System.currentTimeMillis();
    }

    public void setDisplayTimeout(int displayTime) {
        this.displayTimeout = displayTime;
    }

    public String toString() {
        return "{" + this.connId + " " + this.username + "}";
    }
}

