/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.types;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;

public class InSimTime {
    private static DecimalFormat formatter = new DecimalFormat("00");
    private static DecimalFormat formatterThoutands = new DecimalFormat("00");
    private static DecimalFormat formatterOne = new DecimalFormat("0");
    private int time;

    public InSimTime(ByteBuffer buffer) throws BufferUnderflowException {
        this.time = buffer.getInt();
    }

    public InSimTime(int time) {
        this.time = time;
    }

    public String toString() {
        String result = "";
        if (this.getHours() > 0) {
            result = result + formatter.format(this.getHours()) + ":";
        }
        if (result.length() > 0 || this.getMinutes() > 0) {
            result = result + formatter.format(this.getMinutes()) + ":";
        }
        result = result.length() > 0 ? result + formatter.format(this.getSeconds()) : result + formatterOne.format(this.getSeconds());
        return result + "." + formatterThoutands.format(this.getThousandths() / 10);
    }

    public static String toString(int time) {
        return InSimTime.toString(time, false);
    }

    public static String toString(int time, boolean sign) {
        if (!sign) {
            return new InSimTime(time).toString();
        }
        if (time > 0) {
            return "^2-" + new InSimTime(time).toString();
        }
        return "^1+" + new InSimTime(-time).toString();
    }

    public int getHours() {
        return this.time / 3600000;
    }

    public int getMinutes() {
        return this.time % 3600000 / 60000;
    }

    public int getSeconds() {
        return this.time % 60000 / 1000;
    }

    public int getThousandths() {
        return this.time % 1000;
    }

    public int getTime() {
        return this.time;
    }
}

