/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.types;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.types.InSimVector;
import net.sf.jinsim.types.NodeLap;

public class CompCar {
    private static int BLUE = 1;
    private static int YELLOW = 2;
    private static int FIRST = 64;
    private static int LAST = 128;
    private short node;
    private short lap;
    private byte playerId;
    private InSimVector position;
    private short speed;
    private short direction;
    private short heading;
    private short angularVelocity;
    private byte racePosition;
    private byte info;

    public CompCar(ByteBuffer buffer) throws BufferUnderflowException {
        NodeLap nodeLap = new NodeLap(buffer);
        this.setNode(nodeLap.getNode());
        this.setLap(nodeLap.getLap());
        this.setPlayerId(nodeLap.getPlayerId());
        this.racePosition = nodeLap.getPosition();
        this.info = buffer.get();
        buffer.position(buffer.position() + 1);
        this.setPosition(new InSimVector(buffer));
        this.setSpeed(buffer.getShort());
        this.setDirection(buffer.getShort());
        this.setHeading(buffer.getShort());
        this.setAngularVelocity(buffer.getShort());
    }

    public String toString() {
        return "CompCar[Node=" + this.getNode() + " lap=" + this.getLap() + " playerId=" + this.getPlayerId() + " position=" + this.getPosition() + " speed=" + this.getSpeed() + " direction=" + this.getDirection() + " heading=" + this.getHeading() + " angularVelocity: " + this.getAngularVelocity() + "]";
    }

    public short getAngularVelocity() {
        return this.angularVelocity;
    }

    private void setAngularVelocity(short angularVelocity) {
        this.angularVelocity = angularVelocity;
    }

    public short getDirection() {
        return this.direction;
    }

    public float getDirectionInDegrees() {
        return (float)((double)this.direction / 180.0);
    }

    private void setDirection(short direction) {
        this.direction = direction;
    }

    public short getHeading() {
        return this.heading;
    }

    public float getHeadingInDegrees() {
        return (float)((double)this.heading / 180.0);
    }

    private void setHeading(short heading) {
        this.heading = heading;
    }

    public short getLap() {
        return this.lap;
    }

    private void setLap(short lap) {
        this.lap = lap;
    }

    public short getNode() {
        return this.node;
    }

    private void setNode(short node) {
        this.node = node;
    }

    public byte getPlayerId() {
        return this.playerId;
    }

    private void setPlayerId(byte playerId) {
        this.playerId = playerId;
    }

    public short getSpeed() {
        return this.speed;
    }

    private void setSpeed(short speed) {
        this.speed = speed;
    }

    public InSimVector getPosition() {
        return this.position;
    }

    public void setPosition(InSimVector position) {
        this.position = position;
    }

    public byte getRacePosition() {
        return this.racePosition;
    }

    public boolean carIsInTheWay() {
        return (this.info & BLUE) > 0;
    }

    public boolean carIsSlower() {
        return (this.info & YELLOW) > 0;
    }

    public boolean firstPacket() {
        return (this.info & FIRST) > 0;
    }

    public boolean lastPacket() {
        return (this.info & LAST) > 0;
    }
}

