/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.CompCar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCarInfoResponse
extends InSimResponse {
    private byte numberCompCarPackages;
    private ArrayList<CompCar> carInfoList = new ArrayList();

    MultiCarInfoResponse() {
        super(PacketType.MULIT_CAR_INFO);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.numberCompCarPackages = buffer.get();
        for (int i = 0; i < this.numberCompCarPackages; ++i) {
            this.carInfoList.add(new CompCar(buffer));
        }
    }

    @Override
    public String toString() {
        String value = super.toString();
        value = value + "numberCompCarPackages: " + this.numberCompCarPackages;
        for (CompCar compCar : this.carInfoList) {
            value = value + "Car: " + compCar + ", ";
        }
        return value;
    }

    public void addCarInfo(CompCar info) {
        this.carInfoList.add(info);
    }

    public CompCar getCarInfoAt(int n) {
        return this.carInfoList.get(n);
    }

    public ArrayList<CompCar> getCarInfoList() {
        return this.carInfoList;
    }
}

