/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.request;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.request.InSimRequest;

public class ScreenModeRequest
extends InSimRequest {
    private int set16Bit;
    private int refreshRate;
    private int width;
    private int height;

    public ScreenModeRequest() {
        super(PacketType.SCREEN_MODE, 20);
        this.setSet16Bit(0);
        this.setRefreshRate(0);
        this.setWidth(0);
        this.setHeight(0);
    }

    public void assemble(ByteBuffer data) {
        super.assemble(data);
        data.put((byte)0);
        data.putInt(this.getSet16Bit());
        data.putInt(this.getRefreshRate());
        data.putInt(this.getWidth());
        data.putInt(this.getHeight());
    }

    public String toString() {
        String retval = super.toString();
        retval = retval + "16-bit: " + (this.getSet16Bit() == 1 ? "yes" : "no") + "\n";
        retval = retval + "Refresh rate: " + this.getRefreshRate() + "\n";
        retval = retval + "Resolution: " + this.getWidth() + "x" + this.getHeight() + "\n";
        return retval;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public int getSet16Bit() {
        return this.set16Bit;
    }

    public void setSet16Bit(int set16Bit) {
        this.set16Bit = set16Bit;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

