/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.examples.message;

import java.io.IOException;
import net.sf.jinsim.SimpleClient;
import net.sf.jinsim.Sound;
import net.sf.jinsim.TCPChannel;
import net.sf.jinsim.request.MessageExtendedRequest;
import net.sf.jinsim.request.MessageToLocalComputer;
import net.sf.jinsim.response.InSimListener;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.response.MessageResponse;

public class Main
implements InSimListener {
    private SimpleClient client;
    private String hostname;
    private int port;
    private String adminPassword;

    public Main(String[] args) {
        this.hostname = args[0];
        this.port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            this.adminPassword = args[2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.client = new SimpleClient();
            TCPChannel channel = new TCPChannel(this.hostname, this.port);
            this.client.addListener(this);
            this.client.connect(channel, this.adminPassword, "MessageTest");
            MessageExtendedRequest msgRequest = new MessageExtendedRequest();
            msgRequest.setMessage("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
            this.client.send(msgRequest);
            this.client.send(new MessageToLocalComputer("Foobar", Sound.MESSAGE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void packetReceived(InSimResponse response) {
        if (response instanceof MessageResponse) {
            MessageResponse msgResponse = (MessageResponse)response;
            System.out.println(msgResponse.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            Main testConnect = new Main(args);
            testConnect.run();
        } else {
            System.out.println("usage: net.sf.insim.message.Main <hostname> <port> <admin password>");
        }
    }
}

